<?php 
include('partials/_super_header.php');

// Get current page from URL or set to 1
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20; // Number of records per page
$offset = ($page - 1) * $limit;

// Fetch complete profiles with pagination
$api_url = $APIBASE."users/users_exec.php?action=list_users_complete_profile";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$completeProfiles = json_decode($response);
$totalComplete = $completeProfiles ? count($completeProfiles) : 0;
$completePages = ceil($totalComplete / $limit);
$completeProfilesPaginated = array_slice($completeProfiles, $offset, $limit);

// Fetch incomplete profiles with pagination
$api_url = $APIBASE."users/users_exec.php?action=list_users_incomplete_profile";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$incompleteProfiles = json_decode($response);
$totalIncomplete = $incompleteProfiles ? count($incompleteProfiles) : 0;
$incompletePages = ceil($totalIncomplete / $limit);
$incompleteProfilesPaginated = array_slice($incompleteProfiles, $offset, $limit);
?>

<!-- Layout container -->
<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search users..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="profile.php?id=<?php echo $encrypted ?>">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">User Management</h3>
                                    <p class="mb-0">Manage all users in the system with complete and incomplete profiles</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary">
                                            <i class="bx bx-export me-1"></i> Export Data
                                        </button>
                                        <button class="btn btn-primary">
                                            <i class="bx bx-filter me-1"></i> Filters
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Complete Profiles</h6>
                                    <h4 class="stat-value"><?php echo $totalComplete ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 12%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-check-circle bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Incomplete Profiles</h6>
                                    <h4 class="stat-value"><?php echo $totalIncomplete ?></h4>
                                    <span class="stat-change text-warning"><i class="bx bx-up-arrow-alt"></i> 8%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-time bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total Users</h6>
                                    <h4 class="stat-value"><?php echo $totalComplete + $totalIncomplete ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-up-arrow-alt"></i> 15%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-user bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Avg. Completion</h6>
                                    <h4 class="stat-value">72%</h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 5%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-trending-up bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Stats Cards -->

            <!-- Complete Profiles Section -->
            <div class="row mb-4" id="complete">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Complete Profiles</h5>
                            <span class="badge bg-label-success"><?php echo $totalComplete ?> Users</span>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Full Names</th>
                                            <th>Date Of Birth</th>
                                            <th>Email</th>
                                            <th>Whatsapp</th>
                                            <th>Race</th>
                                            <th>Gender</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if($completeProfilesPaginated && count($completeProfilesPaginated) > 0): ?>
                                            <?php foreach($completeProfilesPaginated as $row): 
                                                $url = toURL($row->email);
                                            ?>
                                                <tr>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <?php 
                                                                $avatar = "assets/img/avatars/blackboy.png"; // default
                                                                if(isset($row->gender) && $row->gender == "Female") {
                                                                    $avatar = "assets/img/avatars/blackgirl.jpeg";
                                                                }
                                                                ?>
                                                                <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                                <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $row->date_of_birth ?></td>
                                                    <td><?php echo $row->email ?></td>
                                                    <td><?php echo $row->whatsapp ?></td>
                                                    <td><?php echo $row->race ?></td>
                                                    <td><?php echo $row->gender ?></td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                                <i class="bx bx-dots-vertical-rounded"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item" href="view_user_details.php?id=<?php echo $url ?>">
                                                                    <i class="bx bx-show me-1"></i> View
                                                                </a>
                                                                <a class="dropdown-item" href="assign_user_bursary.php?id=<?php echo $url ?>">
                                                                    <i class="bx bx-transfer-alt me-1"></i> Bursary
                                                                </a>
                                                                <a class="dropdown-item" href="update_user_account.php?id=<?php echo $url ?>">
                                                                    <i class="bx bx-user-pin me-1"></i> User Type
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="7" align="center" class="py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-user-check bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No complete profiles found</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination - Updated Layout -->
                            <?php if($completePages > 1): ?>
                            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3">
                                <div class="text-muted mb-2 mb-md-0">
                                    Showing <?php echo min($limit, count($completeProfilesPaginated)) ?> of <?php echo $totalComplete ?> entries
                                </div>
                                <div class="d-flex flex-column flex-md-row align-items-center">
                                    <nav aria-label="Page navigation" class="mb-2 mb-md-0">
                                        <ul class="pagination pagination-sm mb-0">
                                            <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page - 1; ?>#complete" tabindex="-1">
                                                    <i class="bx bx-chevron-left"></i>
                                                </a>
                                            </li>
                                            
                                            <?php 
                                            // Show limited page numbers with ellipsis
                                            $startPage = max(1, $page - 2);
                                            $endPage = min($completePages, $page + 2);
                                            
                                            if ($startPage > 1) {
                                                echo '<li class="page-item"><a class="page-link" href="?page=1#complete">1</a></li>';
                                                if ($startPage > 2) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                            }
                                            
                                            for($i = $startPage; $i <= $endPage; $i++): ?>
                                                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                                    <a class="page-link" href="?page=<?php echo $i; ?>#complete"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; 
                                            
                                            if ($endPage < $completePages) {
                                                if ($endPage < $completePages - 1) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                                echo '<li class="page-item"><a class="page-link" href="?page='.$completePages.'#complete">'.$completePages.'</a></li>';
                                            }
                                            ?>
                                            
                                            <li class="page-item <?php echo $page >= $completePages ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page + 1; ?>#complete">
                                                    <i class="bx bx-chevron-right"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <div class="text-muted ms-md-2">
                                        Page <?php echo $page; ?> of <?php echo $completePages; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Complete Profiles Section -->

            <!-- Incomplete Profiles Section -->
            <div class="row mb-4" id="in-complete">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Incomplete Profiles</h5>
                            <span class="badge bg-label-warning"><?php echo $totalIncomplete ?> Users</span>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Date Registered</th>
                                            <th>Full Names</th>
                                            <th>Email</th>
                                            <th>Progress</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if($incompleteProfilesPaginated && count($incompleteProfilesPaginated) > 0): ?>
                                            <?php foreach($incompleteProfilesPaginated as $row): 
                                                $url = toURL($row->email);
                                                $progress = (int)$row->profile_ptc;
                                                $status_class = $progress >= 50 ? 'warning' : 'danger';
                                            ?>
                                                <tr>
                                                    <td><?php echo $row->create_date ?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <?php 
                                                                $avatar = "assets/img/avatars/blackboy.png"; // default
                                                                ?>
                                                                <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                                <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $row->email ?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="progress w-px-100 me-2" style="height: 6px;">
                                                                <div class="progress-bar bg-<?php echo $status_class; ?>" role="progressbar" style="width: <?php echo $progress ?>%;" aria-valuenow="<?php echo $progress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <small><?php echo $progress ?>%</small>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-label-<?php echo $status_class; ?>">
                                                            <?php echo $progress >= 50 ? 'In Progress' : 'Just Started'; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                                <i class="bx bx-dots-vertical-rounded"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item" href="view_incomplete_user_details.php?id=<?php echo $url ?>">
                                                                    <i class="bx bx-show me-1"></i> View
                                                                </a>
                                                                <a class="dropdown-item" href="update_user_account.php?id=<?php echo $url ?>">
                                                                    <i class="bx bx-user-pin me-1"></i> User Type
                                                                </a>
                                                                <a class="dropdown-item" href="#">
                                                                    <i class="bx bx-envelope me-1"></i> Send Reminder
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="6" align="center" class="py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-user-x bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No incomplete profiles found</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination - Updated Layout -->
                            <?php if($incompletePages > 1): ?>
                            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3">
                                <div class="text-muted mb-2 mb-md-0">
                                    Showing <?php echo min($limit, count($incompleteProfilesPaginated)) ?> of <?php echo $totalIncomplete ?> entries
                                </div>
                                <div class="d-flex flex-column flex-md-row align-items-center">
                                    <nav aria-label="Page navigation" class="mb-2 mb-md-0">
                                        <ul class="pagination pagination-sm mb-0">
                                            <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page - 1; ?>#in-complete" tabindex="-1">
                                                    <i class="bx bx-chevron-left"></i>
                                                </a>
                                            </li>
                                            
                                            <?php 
                                            // Show limited page numbers with ellipsis
                                            $startPage = max(1, $page - 2);
                                            $endPage = min($incompletePages, $page + 2);
                                            
                                            if ($startPage > 1) {
                                                echo '<li class="page-item"><a class="page-link" href="?page=1#in-complete">1</a></li>';
                                                if ($startPage > 2) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                            }
                                            
                                            for($i = $startPage; $i <= $endPage; $i++): ?>
                                                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                                    <a class="page-link" href="?page=<?php echo $i; ?>#in-complete"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; 
                                            
                                            if ($endPage < $incompletePages) {
                                                if ($endPage < $incompletePages - 1) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                                echo '<li class="page-item"><a class="page-link" href="?page='.$incompletePages.'#in-complete">'.$incompletePages.'</a></li>';
                                            }
                                            ?>
                                            
                                            <li class="page-item <?php echo $page >= $incompletePages ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page + 1; ?>#in-complete">
                                                    <i class="bx bx-chevron-right"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <div class="text-muted ms-md-2">
                                        Page <?php echo $page; ?> of <?php echo $incompletePages; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Incomplete Profiles Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>
<!-- / Layout page -->

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.pagination .page-item.active .page-link {
    background-color: #4A90E2;
    border-color: #4A90E2;
}

/* Responsive pagination */
@media (max-width: 768px) {
    .pagination {
        flex-wrap: wrap;
        justify-content: center;
    }
    
    .pagination .page-item {
        margin-bottom: 5px;
    }
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize any page-specific JavaScript here
});
</script>
</body>
</html>