<?php 
include('partials/_super_header.php');

// Fetch dashboard stats
$api_url = $APIBASE."users/users_exec.php?action=view_super_user_dashboard";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$result = json_decode($response);

// Initialize variables with default values
$total_number_of_users = 0;
$total_institutions = 0;
$total_qualifications = 0;
$total_faculties = 0;
$total_specialization = 0;
$total_new_registrations = 0;
$total_corporate = 0;
$total_super_user = 0;
$total_full_registrations = 0;
$total_inprogress_users = 0;
$registrations_today = 0;

if($result && count($result) > 0){
    foreach($result as $row) {
        $total_number_of_users = $row->total_number_of_users;
        $total_institutions = $row->total_institutions;
        $total_qualifications = $row->total_qualifications;
        $total_faculties = $row->total_faculties;
        $total_specialization = $row->total_specialization;
        $total_new_registrations = $row->total_new_registrations;
        $total_corporate = $row->total_corporate;
        $total_super_user = $row->total_super_user;
        $total_full_registrations = $row->total_full_registrations;
        $total_inprogress_users = $row->total_inprogress_users;
        $registrations_today = $row->registrations_today;
    }
}

// Fetch registration trends data
$api_url = $APIBASE."users/users_exec.php?action=get_registration_trends";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$registrationTrends = json_decode($response);

// Prepare data for registration trends chart - last 12 months including current month
$currentDate = new DateTime();
$monthlyRegistrations = [];
$monthNames = [];

// Generate the last 12 months including current month
for ($i = 11; $i >= 0; $i--) {
    $date = clone $currentDate;
    $date->modify("-$i months");
    
    $month = (int)$date->format('n');
    $year = (int)$date->format('Y');
    $monthName = $date->format('M');
    
    $monthNames[] = $monthName;
    $monthlyRegistrations[] = 0; // Initialize with 0
    
    // Check if we have data for this month/year
    if($registrationTrends && count($registrationTrends) > 0) {
        foreach($registrationTrends as $trend) {
            if ((int)$trend->month === $month && (int)$trend->year === $year) {
                $monthlyRegistrations[count($monthlyRegistrations) - 1] = (int)$trend->registrations;
                break;
            }
        }
    }
}

// Fetch user distribution data
$api_url = $APIBASE."users/users_exec.php?action=get_user_distribution";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$userDistribution = json_decode($response);

$userDistributionLabels = [];
$userDistributionData = [];
if($userDistribution && count($userDistribution) > 0) {
    foreach($userDistribution as $dist) {
        $userDistributionLabels[] = ucfirst($dist->user_type);
        $userDistributionData[] = (int)$dist->count;
    }
}

// Calculate percentages for progress bars
$maxUsers = max(1000, $total_number_of_users);
$maxInstitutions = max(200, $total_institutions);
$maxQualifications = max(500, $total_qualifications);
$maxFaculties = max(50, $total_faculties);
$maxSpecializations = max(100, $total_specialization);

$userProgress = min(100, ($total_number_of_users / $maxUsers) * 100);
$institutionProgress = min(100, ($total_institutions / $maxInstitutions) * 100);
$qualificationProgress = min(100, ($total_qualifications / $maxQualifications) * 100);
$facultyProgress = min(100, ($total_faculties / $maxFaculties) * 100);
$specializationProgress = min(100, ($total_specialization / $maxSpecializations) * 100);
?>

<style>

.bursary-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.bursary-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

</style>

<!-- Layout container -->
<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search users, institutions..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- Notifications -->
                <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-2">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <i class="bx bx-bell bx-sm"></i>
                        <span class="badge bg-danger rounded-pill badge-notifications">3</span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end py-0">
                        <li class="dropdown-menu-header border-bottom">
                            <div class="dropdown-header d-flex align-items-center py-3">
                                <h5 class="text-body mb-0 me-auto">Notifications</h5>
                                <span class="badge rounded-pill bg-label-primary">3 New</span>
                            </div>
                        </li>
                        <li class="dropdown-notifications-list scrollable-container">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="avatar">
                                                <span class="avatar-initial rounded-circle bg-label-success"><i class="bx bx-user-plus"></i></span>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">New user registered</h6>
                                            <p class="mb-0">John Doe just signed up</p>
                                            <small class="text-muted">5 mins ago</small>
                                        </div>
                                    </div>
                                </li>
                                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="avatar">
                                                <span class="avatar-initial rounded-circle bg-label-info"><i class="bx bx-building"></i></span>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">New institution added</h6>
                                            <p class="mb-0">Cape Town University added</p>
                                            <small class="text-muted">1 hour ago</small>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </li>
                        <li class="dropdown-menu-footer border-top">
                            <a href="javascript:void(0);" class="dropdown-item d-flex justify-content-center text-primary p-2 h-100">
                                View all notifications
                            </a>
                        </li>
                    </ul>
                </li>
                <!-- /Notifications -->

                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Welcome Card -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card welcome-card">
                        <div class="card-body p-4">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Welcome back, <?php echo $_SESSION['fullnames'] ?>! 👋</h3>
                                    <p class="mb-4">Here's what's happening with your platform today. Monitor user activity, track progress, and manage your system efficiently.</p>
                                    <a href="individuals.php?id=<?php echo $encrypted ?>" class="btn btn-primary">View User Progress</a>
                                </div>
                                
                                <div class="col-md-4 text-center">
                                    <img src="assets/img/illustrations/dashboard-analytics-light.png" height="160" alt="Dashboard Analytics">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Welcome Card -->


            <div class="row mb-4">
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Users</h6>
                                    <h4 class="stat-value"><?php echo $total_number_of_users ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 12%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-user bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: <?php echo $userProgress ?>%;" aria-valuenow="<?php echo $userProgress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>            
            
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Institutions</h6>
                                    <h4 class="stat-value"><?php echo $total_institutions ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 8%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-building bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: 60%;" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Qualifications</h6>
                                    <h4 class="stat-value"><?php echo $total_qualifications ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 15%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-book bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: 85%;" aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Faculties</h6>
                                    <h4 class="stat-value"><?php echo $total_faculties ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 5%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-group bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: 45%;" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Specializations</h6>
                                    <h4 class="stat-value"><?php echo $total_specialization ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 10%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-danger p-2 rounded">
                                        <i class="bx bx-certification bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: 70%;" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Active Sessions</h6>
                                    <h4 class="stat-value">42</h4>
                                    <span class="stat-change text-danger"><i class="bx bx-down-arrow-alt"></i> 3%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-secondary p-2 rounded">
                                        <i class="bx bx-network-chart bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="stat-progress mt-3">
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar" role="progressbar" style="width: 55%;" aria-valuenow="55" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Stats Overview -->

            <!-- Charts Row -->
            <div class="row mb-4">
                <div class="col-lg-8 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Registration Trends (Last 12 Months)</h5>
                            <div class="dropdown">
                                <button class="btn p-0" type="button" id="chartDropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="chartDropdown">
                                    <a class="dropdown-item" href="javascript:void(0);">Last 7 Days</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Last 30 Days</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Last 90 Days</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="registrationChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">User Type Distribution</h5>
                        </div>
                        <div class="card-body">
                            <div id="userDistributionChart" style="min-height: 300px;"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Charts Row -->

            <!-- Add this to your dashboard after the stats cards -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Active Bursary Programs</h5>
                            <a href="manage_bursaries.php?id=<?php echo toURL(rand()) ?>" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <?php
                                // Fetch active bursaries
                                $api_url = $APIBASE."users/users_exec.php?action=get_active_bursaries";
                                $client = curl_init($api_url);
                                curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
                                $response = curl_exec($client);
                                $activeBursaries = json_decode($response);
                                
                                if($activeBursaries && count($activeBursaries) > 0): 
                                    foreach($activeBursaries as $bursary):
                                        $days_remaining = floor((strtotime($bursary->application_end_date) - time()) / (60 * 60 * 24));
                                ?>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card bursary-card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <span class="badge bg-success">Active</span>
                                                <span class="badge bg-info"><?php echo $days_remaining; ?> days left</span>
                                            </div>
                                            <h6 class="card-title"><?php echo $bursary->project_name; ?></h6>
                                            <p class="card-text text-muted small"><?php echo $bursary->funder_name; ?></p>
                                            <div class="mb-2">
                                                <?php if($bursary->funding_amount): ?>
                                                    <strong>R<?php echo number_format($bursary->funding_amount, 2); ?></strong>
                                                <?php endif; ?>
                                                <?php if($bursary->field_of_study): ?>
                                                    <span class="text-muted">• <?php echo $bursary->field_of_study; ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <small class="text-muted">Ends: <?php echo date('M j, Y', strtotime($bursary->application_end_date)); ?></small>
                                                <a href="edit_bursary.php?id=<?php echo $bursary->bursary_id; ?>" class="btn btn-sm btn-outline-primary">View</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                                <?php else: ?>
                                <div class="col-12">
                                    <div class="text-center py-4">
                                        <i class="bx bx-money bx-lg text-muted mb-2"></i>
                                        <p class="text-muted mb-0">No active bursary programs</p>
                                        <a href="add_bursary.php?id=<?php echo toURL(rand()) ?>" class="btn btn-primary mt-2">
                                            <i class="bx bx-plus me-1"></i> Add Bursary Program
                                        </a>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Users Table -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Active Users</h5>
                            <div>
                                <button class="btn btn-sm btn-outline-secondary">
                                    <i class="bx bx-export me-1"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>User</th>
                                            <th>Email</th>
                                            <th>Contact</th>
                                            <th>Status</th>
                                            <th>Progress</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php
                                        $api_url = $APIBASE."users/users_exec.php?action=list_all_system_users_limit";
                                        $client = curl_init($api_url);
                                        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
                                        $response = curl_exec($client);
                                        $result = json_decode($response);

                                        if(count($result) > 0) {
                                            foreach($result as $row) {
                                                $url = toURL($row->email);
                                                $progress = rand(30, 100); // Simulated progress percentage
                                        ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-3">
                                                        <?php if ($row->gender == "Male"){ ?>
                                                        <img src="assets/img/avatars/blackboy.png" alt class="w-px-30 h-auto rounded-circle" />
                                                        <?php } else { ?>
                                                        <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-30 h-auto rounded-circle" />
                                                        <?php } ?>
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                        <small class="text-muted"><?php echo $row->race ?></small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo $row->email ?></td>
                                            <td><?php echo $row->whatsapp ?></td>
                                            <td>
                                                <span class="badge bg-label-success">Active</span>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="progress w-px-100 me-2" style="height: 6px;">
                                                        <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo $progress ?>%;" aria-valuenow="<?php echo $progress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <small><?php echo $progress ?>%</small>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="dropdown">
                                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="view_user_details.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-show me-1"></i> View
                                                        </a>
                                                        <a class="dropdown-item" href="javascript:void(0);">
                                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                                        </a>
                                                        <a class="dropdown-item" href="javascript:void(0);">
                                                            <i class="bx bx-envelope me-1"></i> Message
                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php
                                            }
                                        } else {
                                        ?>
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <div class="d-flex flex-column align-items-center">
                                                    <i class="bx bx-user-x bx-lg text-muted mb-2"></i>
                                                    <p class="text-muted mb-0">No users found</p>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Active Users Table -->
        </div>
        <!-- / Content -->

        <div class="content-backdrop fade"></div>
    </div>
    <!-- Content wrapper -->
</div>
<!-- / Layout page -->

<!-- Custom CSS -->
<style>
.welcome-card {
    background: linear-gradient(135deg, #4A90E2 0%, #2A5799 100%);
    color: white;
    border: none;
    box-shadow: 0 4px 20px rgba(74, 144, 226, 0.3);
}

.welcome-card .text-primary {
    color: white !important;
}

.welcome-card .btn-primary {
    background-color: rgba(255, 255, 255, 0.2);
    border-color: rgba(255, 255, 255, 0.3);
    color: white;
}

.welcome-card .btn-primary:hover {
    background-color: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.4);
}

.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.dropdown-notifications .dropdown-menu {
    width: 360px;
}

.dropdown-notifications-item {
    padding: 0.75rem 1rem;
    border-bottom: 1px solid #e9ecef;
}

.dropdown-notifications-item:last-child {
    border-bottom: none;
}

.avatar-initial {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 2.5rem;
    height: 2.5rem;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>
<script src="assets/js/main.js"></script>

<!-- Dashboard Charts -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Registration Trends Chart
    var registrationChartOptions = {
        series: [{
            name: 'Registrations',
            data: <?php echo json_encode($monthlyRegistrations); ?>
        }],
        chart: {
            height: 350,
            type: 'area',
            toolbar: {
                show: false
            }
        },
        colors: ['#4A90E2'],
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'smooth',
            width: 2
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.3,
                stops: [0, 90, 100]
            }
        },
        xaxis: {
            categories: <?php echo json_encode($monthNames); ?>,
            labels: {
                rotate: -45
            }
        },
        tooltip: {
            x: {
                format: 'MMM YYYY'
            }
        }
    };

    var registrationChart = new ApexCharts(document.querySelector("#registrationChart"), registrationChartOptions);
    registrationChart.render();

    // User Distribution Chart
    var userDistributionOptions = {
        series: <?php echo json_encode($userDistributionData); ?>,
        labels: <?php echo json_encode($userDistributionLabels); ?>,
        chart: {
            type: 'donut',
            height: 300
        },
        colors: ['#4A90E2', '#36B37E', '#FFAB00', '#FF5630', '#6554C0'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }],
        legend: {
            position: 'bottom',
            offsetY: 0
        }
    };

    var userDistributionChart = new ApexCharts(document.querySelector("#userDistributionChart"), userDistributionOptions);
    userDistributionChart.render();

    // Profile Completion Chart
    var profileCompletionOptions = {
        series: <?php echo json_encode($profileCompletionData); ?>,
        labels: <?php echo json_encode($profileCompletionLabels); ?>,
        chart: {
            type: 'donut',
            height: 300
        },
        colors: ['#4A90E2', '#36B37E', '#FFAB00', '#6c757d', '#FF5630', '#28a745'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }],
        legend: {
            position: 'bottom',
            offsetY: 0
        },
        plotOptions: {
            pie: {
                donut: {
                    labels: {
                        show: true,
                        total: {
                            show: true,
                            label: 'Total Users',
                            formatter: function (w) {
                                return w.globals.seriesTotals.reduce((a, b) => {
                                    return a + b
                                }, 0)
                            }
                        }
                    }
                }
            }
        }
    };

    var profileCompletionChart = new ApexCharts(document.querySelector("#profileCompletionChart"), profileCompletionOptions);
    profileCompletionChart.render();
});
</script>
</body>
</html>