<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
    // Server settings
    // $mail->SMTPDebug = SMTP::DEBUG_SERVER; // Enable verbose debug output
    $mail->isSMTP(); // Send using SMTP
    $mail->Host = 'smtp.gmail.com'; // Set the SMTP server to send through
    $mail->SMTPAuth = true; // Enable SMTP authentication
    $mail->Username = 'levelsappnoreply@gmail.com'; // SMTP username
    $mail->Password = 'cugdmbzmlsjzrpfv'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Enable implicit TLS encryption
    $mail->Port = 465; // TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    // Recipients
    $mail->setFrom('levelsappnoreply@gmail.com', 'LevelsApp');
    $mail->addAddress($_POST['email'], $_POST['full_names']); // Add a recipient
    $mail->addReplyTo('no-reply@levelupcareers.co.za', 'LevelsApp Support');

    // Content
    $mail->isHTML(true); // Set email format to HTML
    
    // Set subject based on upload type and status
    $subject = $_POST['upload_type'] . ' document - ' . $_POST['status'];
    $mail->Subject = $subject;
    
    // Rich HTML email body with LevelsApp theme for document feedback
    $mail->Body = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Document Status Update</title>
        <style>
            body, table, td, a {
                -webkit-text-size-adjust: 100%;
                -ms-text-size-adjust: 100%;
            }
            table, td {
                mso-table-lspace: 0pt;
                mso-table-rspace: 0pt;
                border-collapse: collapse;
            }
            img {
                -ms-interpolation-mode: bicubic;
                border: 0;
                height: auto;
                line-height: 100%;
                outline: none;
                text-decoration: none;
            }
            .container {
                max-width: 600px;
                margin: 0 auto;
            }
            .body-text {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 16px;
                line-height: 1.5;
                color: #333333;
            }
            .status-badge {
                display: inline-block;
                padding: 8px 15px;
                border-radius: 20px;
                font-weight: bold;
                margin: 10px 0;
            }
            .status-approved {
                background: #E7F6EC;
                color: #0E6245;
            }
            .status-rejected {
                background: #FFE9E9;
                color: #D32F2F;
            }
            .status-pending {
                background: #FFF4E6;
                color: #E67E22;
            }
            .message-container {
                background: #F8F9FA;
                padding: 20px;
                border-radius: 8px;
                border-left: 4px solid #4A90E2;
                margin: 20px 0;
                font-style: italic;
            }
            .button {
                background: #4A90E2;
                color: #ffffff;
                padding: 12px 25px;
                text-decoration: none;
                border-radius: 5px;
                display: inline-block;
                font-weight: bold;
            }
            @media screen and (max-width: 600px) {
                .flex-container {
                    display: block !important;
                    width: 100% !important;
                }
                .flex-item {
                    display: block !important;
                    width: 100% !important;
                    margin-bottom: 15px;
                }
            }
        </style>
    </head>
    <body style="margin: 0; padding: 0; background-color: #f5f5f5;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
                <td align="center" style="padding: 20px 0;">
                    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width: 600px;">
                        <tr>
                            <td style="background: #ffffff; padding: 20px; text-align: center; border-radius: 5px 5px 0 0;">
                                <img src="https://levelupcareers.co.za/assets/img/logo/logo.png" alt="LevelsApp Logo" width="200" style="display: inline-block;">
                            </td>
                        </tr>
                        
                        <tr>
                            <td style="background: #ffffff; padding: 30px 20px;">
                                <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td class="body-text">
                                            <h2 style="color: #4A90E2; margin-top: 0; text-align: center;">Document Status Update</h2>
                                            
                                            <p>Dear <strong>'.htmlspecialchars($fullnames).'</strong>,</p>
                                            
                                            <p>Regarding the <strong>'.htmlspecialchars($_POST['upload_type']).'</strong> document you uploaded on <strong>'.htmlspecialchars($_POST['uploaded_on']).'</strong>:</p>
                                            
                                            <div style="text-align: center; margin: 20px 0;">
                                                <span class="status-badge status-'.strtolower($status).'">'.htmlspecialchars($status).'</span>
                                            </div>
                                            
                                            <p>The document has been <strong>'.htmlspecialchars($status).'</strong>.</p>
                                            
                                            <div class="message-container">
                                                <strong>Feedback:</strong><br>
                                                '.nl2br(htmlspecialchars($upload_feedback)).'
                                            </div>

                                            <p>You can login to the system to view all your uploads and their status.</p>

                                            <div style="text-align: center; margin: 25px 0;">
                                                <a href="https://levelupcareers.co.za/dashboard" class="button">View My Documents</a>
                                            </div>

                                            <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%" style="background: #E8F4FD; padding: 15px; border-radius: 5px; margin: 20px 0;">
                                                <tr>
                                                    <td>
                                                        <h4 style="margin-top: 0; color: #4A90E2;">📋 Document Information</h4>
                                                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                                            <tr>
                                                                <td width="30%" style="padding: 5px 0;"><strong>Document Type:</strong></td>
                                                                <td style="padding: 5px 0;">'.htmlspecialchars($upload_type).'</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px 0;"><strong>Upload Date:</strong></td>
                                                                <td style="padding: 5px 0;">'.htmlspecialchars($uploaded_on).'</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px 0;"><strong>Status:</strong></td>
                                                                <td style="padding: 5px 0;">'.htmlspecialchars($status).'</td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>

                                            <hr style="border: none; border-top: 1px solid #eee; margin: 30px 0;">

                                            <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                                <tr>
                                                    <td style="text-align: center;">
                                                        <h4 style="color: #4A90E2;">Need Assistance?</h4>
                                                        <p>Our support team is here to help you with any questions about document submissions</p>
                                                        <p>📧 <a href="mailto:support@levelupcareers.co.za" style="color: #4A90E2;">support@levelupcareers.co.za</a><br>
                                                        📞 <a href="tel:+27861777022" style="color: #4A90E2;">086 177 7022</a></p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <tr>
                            <td style="background: #4A90E2; padding: 15px; text-align: center; border-radius: 0 0 5px 5px;">
                                <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td style="color: #ffffff; font-size: 12px;">
                                            <p style="margin: 0;">&copy; 2025 LevelsApp. All rights reserved.<br>
                                            <a href="https://levelupcareers.co.za" style="color: #ffffff; text-decoration: underline;">Visit our website</a> | <a href="#" style="color: #ffffff; text-decoration: underline;">Privacy Policy</a></p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>';
    
    // Plain text alternative
    $mail->AltBody = "Document Status Update\n\nDear ".$_POST['full_names'].",\n\nRegarding the ".$_POST['upload_type']." document you uploaded on ".$_POST['uploaded_on'].":\n\nThe document has been ".$_POST['status'].".\n\nFeedback provided: ".$_POST['upload_feedback'].".\n\nYou can login to the system to view all your uploads and their status.\n\nLogin: https://levelupcareers.co.za/dashboard\n\nNeed assistance? Contact our support team:\nEmail: support@levelupcareers.co.za\nPhone: 086 177 7022\n\n© 2023 LevelsApp. All rights reserved.";

    $mail->send();
    
    echo "Document feedback email sent successfully!";
    
} catch (Exception $e) {
    echo "Error sending email: " . $e->getMessage();
}

$mail->clearAllRecipients(); // Clear all recipient types(to, bcc, cc).
?>