<?php
include('partials/_super_header.php');

// Get bursary ID from URL
$bursary_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch bursary details
$bursary = null;
if ($bursary_id > 0) {
    $api_url = $APIBASE."users/users_exec.php?action=get_bursary_by_id&id=".$bursary_id;
    $client = curl_init($api_url);
    curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($client);
    $result = json_decode($response);
    
    if($result && count($result) > 0){
        $bursary = $result[0];
    }
}

// Redirect if bursary not found
if (!$bursary) {
    header("Location: manage_bursaries.php?id=".toURL(rand()));
    exit();
}

// Get current user ID from session
$created_by = $_SESSION['user_id'] ?? 1;
?>

<div class="layout-page">
    <!-- Navbar -->
    
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Edit Bursary Program</h3>
                                    <p class="mb-0">Update the details of <?php echo htmlspecialchars($bursary->project_name); ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="manage_bursaries.php?id=<?php echo toURL(rand()) ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-list-ul me-1"></i> Back to List
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Bursary Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Bursary Program Details</h5>
                        </div>
                        <div class="card-body">
                            <form id="bursaryForm" action="<?php echo $APIBASE; ?>users/users_exec.php?action=update_bursary_program" method="POST">
                                <input type="hidden" name="bursary_id" value="<?php echo $bursary->bursary_id; ?>">
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Funder/Organization Name *</label>
                                        <input type="text" class="form-control" name="funder_name" value="<?php echo htmlspecialchars($bursary->funder_name); ?>" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Bursary Program Name *</label>
                                        <input type="text" class="form-control" name="project_name" value="<?php echo htmlspecialchars($bursary->project_name); ?>" required>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Person *</label>
                                        <input type="text" class="form-control" name="contact_person" value="<?php echo htmlspecialchars($bursary->contact_person); ?>" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Email *</label>
                                        <input type="email" class="form-control" name="contact_email" value="<?php echo htmlspecialchars($bursary->contact_email); ?>" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Phone *</label>
                                        <input type="tel" class="form-control" name="contact_phone" value="<?php echo htmlspecialchars($bursary->contact_phone); ?>" required>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Application End Date *</label>
                                        <input type="date" class="form-control" name="application_end_date" value="<?php echo $bursary->application_end_date; ?>" required min="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Funding Amount (ZAR)</label>
                                        <input type="number" class="form-control" name="funding_amount" value="<?php echo $bursary->funding_amount; ?>" step="0.01" placeholder="e.g., 50000.00">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Field of Study</label>
                                        <input type="text" class="form-control" name="field_of_study" value="<?php echo htmlspecialchars($bursary->field_of_study); ?>" placeholder="e.g., Engineering, Medicine, etc.">
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Academic Requirements</label>
                                        <textarea class="form-control" name="academic_requirements" rows="3" placeholder="Minimum academic requirements..."><?php echo htmlspecialchars($bursary->academic_requirements); ?></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Demographic Filters</label>
                                        <textarea class="form-control" name="demographic_filters" rows="3" placeholder="Gender, race, location requirements..."><?php echo htmlspecialchars($bursary->demographic_filters); ?></textarea>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-12">
                                        <label class="form-label">Basic Requirements</label>
                                        <textarea class="form-control" name="basic_requirements" rows="4" placeholder="Basic application requirements..."><?php echo htmlspecialchars($bursary->basic_requirements); ?></textarea>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <div class="col-12">
                                        <label class="form-label">Terms & Conditions</label>
                                        <textarea class="form-control" name="terms_conditions" rows="5" placeholder="Program terms and conditions..."><?php echo htmlspecialchars($bursary->terms_conditions); ?></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bx bx-save me-1"></i> Update Bursary Program
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary" onclick="window.history.back()">
                                            <i class="bx bx-arrow-back me-1"></i> Cancel
                                        </button>
                                        <button type="button" class="btn btn-danger float-end" onclick="deleteBursary(<?php echo $bursary->bursary_id; ?>)">
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Bursary Form -->

            <!-- Status Information -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Program Status</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <?php
                                    $end_date = new DateTime($bursary->application_end_date);
                                    $today = new DateTime();
                                    $is_active = $end_date >= $today;
                                    $status_class = $is_active ? 'success' : 'secondary';
                                    $days_remaining = $end_date->diff($today)->days;
                                    ?>
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <span class="badge bg-label-<?php echo $status_class; ?> p-2">
                                                <i class="bx bx-<?php echo $is_active ? 'check-circle' : 'time'; ?> bx-sm"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h6 class="mb-1">Current Status: 
                                                <span class="badge bg-<?php echo $status_class; ?>">
                                                    <?php echo $is_active ? 'Active' : 'Expired'; ?>
                                                </span>
                                            </h6>
                                            <p class="mb-0 text-muted">
                                                <?php if ($is_active): ?>
                                                    Applications close in <?php echo $days_remaining; ?> days (<?php echo $end_date->format('M j, Y'); ?>)
                                                <?php else: ?>
                                                    Applications closed <?php echo $days_remaining; ?> days ago (<?php echo $end_date->format('M j, Y'); ?>)
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <span class="badge bg-label-info p-2">
                                                <i class="bx bx-calendar bx-sm"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h6 class="mb-1">Program Created</h6>
                                            <p class="mb-0 text-muted">
                                                <?php echo date('M j, Y \a\t g:i A', strtotime($bursary->created_at)); ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Status Information -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Form Validation Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('bursaryForm');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Basic validation
        const requiredFields = form.querySelectorAll('[required]');
        let valid = true;
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                valid = false;
                field.classList.add('is-invalid');
            } else {
                field.classList.remove('is-invalid');
            }
        });
        
        if (valid) {
            // Submit form via AJAX
            const formData = new FormData(form);
            
            fetch(form.action, {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data[0].success === '1') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Bursary program updated successfully!',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = 'manage_bursaries.php?id=<?php echo toURL(rand()) ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to update bursary program. Please try again.',
                        confirmButtonText: 'OK'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'An error occurred. Please try again.',
                    confirmButtonText: 'OK'
                });
            });
        }
    });
});

function deleteBursary(id) {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this! All applications for this bursary will also be deleted.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch('<?php echo $APIBASE; ?>users/users_exec.php?action=delete_bursary_program&id=' + id)
                .then(response => response.json())
                .then(data => {
                    if (data[0].success === '1') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted!',
                            text: 'Bursary program has been deleted.',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = 'manage_bursaries.php?id=<?php echo toURL(rand()) ?>';
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Failed to delete bursary program.',
                            confirmButtonText: 'OK'
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'An error occurred while deleting the bursary.',
                        confirmButtonText: 'OK'
                    });
                });
        }
    });
}
</script>

<style>
.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.badge.bg-label-success {
    background-color: rgba(40, 167, 69, 0.1);
    color: #28a745;
}

.badge.bg-label-secondary {
    background-color: rgba(108, 117, 125, 0.1);
    color: #6c757d;
}

.badge.bg-label-info {
    background-color: rgba(23, 162, 184, 0.1);
    color: #17a2b8;
}
</style>

<?php include('partials/_super_footer.php'); ?>