<?php 
include('partials/_header.php');

// Fetch user dashboard data
$api_url = $APIBASE."users/users_exec.php?action=view_user_dashboard&email=".$un_encrypted."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$result = json_decode($response);

if(count($result) > 0){
    foreach($result as $row) {
        $number_of_uploaded_documents = $row->number_of_uploaded_documents;
    }
}

$uploaded_docs_pct = ($number_of_uploaded_documents / 11) * 100;

// Fetch academic interests
$api_url = $APIBASE."users/users_exec.php?action=list_user_academics&email=".$un_encrypted."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$academic_data = json_decode($response);

if(count($academic_data) > 0){
    foreach($academic_data as $row) {
        $where_tostudy_one = $row->where_tostudy_one;
        $where_tostudy_two = $row->where_tostudy_two;
        $where_tostudy_three = $row->where_tostudy_three;
        $what_tostudy_one = $row->what_tostudy_one;
        $what_tostudy_two = $row->what_tostudy_two;
        $what_tostudy_three = $row->what_tostudy_three;              
    }
}

// Fetch recent activities (placeholder - would need actual API endpoint)
$recent_activities = [
    ['icon' => 'bx-cloud-upload', 'action' => 'Uploaded ID Document', 'time' => '2 hours ago'],
    ['icon' => 'bx-book-bookmark', 'action' => 'Updated academic interests', 'time' => '1 day ago'],
    ['icon' => 'bx-check-circle', 'action' => 'Completed profile section', 'time' => '2 days ago']
];
?>
        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
              </a>
            </div>

            <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
              <!-- Search -->
              <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                  <i class="bx bx-search fs-4 lh-0"></i>
                  <input type="text" class="form-control border-0 shadow-none" placeholder="Search courses, institutions..." aria-label="Search..."/>
                </div>
              </div>
              <!-- /Search -->

              <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- Notification bell -->
                <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-2">
                  <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                    <i class="bx bx-bell bx-sm"></i>
                    <span class="badge bg-danger rounded-pill badge-notifications">3</span>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar">
                              <span class="avatar-initial rounded-circle bg-label-warning"><i class="bx bx-calendar-event"></i></span>
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block">Application Deadline</span>
                            <small class="text-muted">University of Johannesburg closes in 3 days</small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item text-center" href="#">View all notifications</a>
                    </li>
                  </ul>
                </li>

                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                  <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                    <div class="avatar avatar-online">
                      <?php if ($gender == "Male"){ ?>
                      <img src="assets/img/avatars/avatar-student-male.png" alt class="w-px-40 h-auto rounded-circle" />
                      <?php } else { ?>
                      <img src="assets/img/avatars/avatar-student-female.png" alt class="w-px-40 h-auto rounded-circle" />
                      <?php } ?>
                    </div>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar avatar-online">
                              <?php if ($gender == "Male"){ ?>
                                <img src="assets/img/avatars/avatar-student-male.png" alt class="w-px-40 h-auto rounded-circle" />
                              <?php } else { ?>
                                <img src="assets/img/avatars/avatar-student-female.png" alt class="w-px-40 h-auto rounded-circle" />
                              <?php } ?>
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                            <small class="text-muted">Student Learner</small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="profile.php?id=<?php echo $encrypted ?>">
                        <i class="bx bx-user me-2"></i>
                        <span class="align-middle">My Profile</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-cog me-2"></i>
                        <span class="align-middle">Settings</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-help-circle me-2"></i>
                        <span class="align-middle">Help & Support</span>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="logout.php">
                        <i class="bx bx-power-off me-2"></i>
                        <span class="align-middle">Log Out</span>
                      </a>
                    </li>
                  </ul>
                </li>
                <!--/ User -->
              </ul>
            </div>
          </nav>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <!-- Welcome Card -->
              <div class="row">
                <div class="col-lg-8 mb-4 order-0">
                  <div class="card learner-welcome-card">
                    <div class="d-flex align-items-end row">
                      <div class="col-sm-7">
                        <div class="card-body">
                          <h5 class="card-title text-primary">Welcome back, <?php echo $firstname ?>! 👋</h5>
                          <p class="mb-4">
                            Your educational journey continues. You've completed <span class="fw-bold"><?php echo round($uploaded_docs_pct,2) ?>%</span> of your profile. 
                            Keep going to unlock more opportunities!
                          </p>

                          <div class="progress mb-4" style="height: 10px;">
                            <div class="progress-bar" role="progressbar" style="width: <?php echo $uploaded_docs_pct ?>%;" 
                                 aria-valuenow="<?php echo $uploaded_docs_pct ?>" aria-valuemin="0" aria-valuemax="100"></div>
                          </div>

                          <div class="d-flex gap-2">
                            <a href="uploads.php?id=<?php echo $encrypted ?>" class="btn btn-primary">Complete Profile</a>
                            <a href="profile.php?id=<?php echo $encrypted ?>" class="btn btn-outline-secondary">View Profile</a>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-5 text-center text-sm-left">
                        <div class="card-body pb-0 px-0 px-md-4">
                          <img src="assets/img/illustrations/student-with-books.png" height="160" alt="Student with books" />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                
                <!-- Quick Stats -->
                <div class="col-lg-4 col-md-6 mb-4 order-1">
                  <div class="card h-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <h5 class="card-title m-0 me-2">Quick Stats</h5>
                      <div class="dropdown">
                        <button class="btn p-0" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <i class="bx bx-dots-vertical-rounded"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                          <a class="dropdown-item" href="javascript:void(0);">Refresh</a>
                        </div>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="d-flex mb-3">
                        <div class="avatar flex-shrink-0 me-3">
                          <span class="avatar-initial rounded bg-label-primary"><i class="bx bx-file"></i></span>
                        </div>
                        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                          <div class="me-2">
                            <h6 class="mb-0">Documents Uploaded</h6>
                            <small class="text-muted">Profile completion</small>
                          </div>
                          <div class="user-progress">
                            <span class="fw-semibold"><?php echo $number_of_uploaded_documents ?>/11</span>
                          </div>
                        </div>
                      </div>
                      <div class="d-flex mb-3">
                        <div class="avatar flex-shrink-0 me-3">
                          <span class="avatar-initial rounded bg-label-success"><i class="bx bx-check-circle"></i></span>
                        </div>
                        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                          <div class="me-2">
                            <h6 class="mb-0">Applications</h6>
                            <small class="text-muted">Submitted this month</small>
                          </div>
                          <div class="user-progress">
                            <span class="fw-semibold">0</span>
                          </div>
                        </div>
                      </div>
                      <div class="d-flex">
                        <div class="avatar flex-shrink-0 me-3">
                          <span class="avatar-initial rounded bg-label-info"><i class="bx bx-time"></i></span>
                        </div>
                        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                          <div class="me-2">
                            <h6 class="mb-0">Pending Tasks</h6>
                            <small class="text-muted">To complete profile</small>
                          </div>
                          <div class="user-progress">
                            <span class="fw-semibold"><?php echo 11 - $number_of_uploaded_documents ?></span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Action Cards -->
              <div class="row">
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                  <div class="card action-card">
                    <div class="card-body text-center">
                      <div class="avatar flex-shrink-0 mb-3">
                        <span class="avatar-initial rounded bg-label-primary p-3">
                          <i class="bx bx-book-open fs-1"></i>
                        </span>
                      </div>
                      <h5 class="card-title">My Applications</h5>
                      <p class="card-text">Track your bursary and university applications</p>
                      <a href="#my_applications" class="btn btn-outline-primary">View Applications</a>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                  <div class="card action-card">
                    <div class="card-body text-center">
                      <div class="avatar flex-shrink-0 mb-3">
                        <span class="avatar-initial rounded bg-label-success p-3">
                          <i class="bx bx-wallet fs-1"></i>
                        </span>
                      </div>
                      <h5 class="card-title">Bursaries</h5>
                      <p class="card-text">Find funding opportunities for your studies</p>
                      <a href="#bursaries_list" class="btn btn-outline-success">Explore Bursaries</a>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                  <div class="card action-card">
                    <div class="card-body text-center">
                      <div class="avatar flex-shrink-0 mb-3">
                        <span class="avatar-initial rounded bg-label-info p-3">
                          <i class="bx bx-building-house fs-1"></i>
                        </span>
                      </div>
                      <h5 class="card-title">Where to Study</h5>
                      <p class="card-text">Discover institutions that match your interests</p>
                      <a href="#intrested_institutions_list" class="btn btn-outline-info">Find Institutions</a>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-md-6 col-6 mb-4">
                  <div class="card action-card">
                    <div class="card-body text-center">
                      <div class="avatar flex-shrink-0 mb-3">
                        <span class="avatar-initial rounded bg-label-warning p-3">
                          <i class="bx bx-graduation fs-1"></i>
                        </span>
                      </div>
                      <h5 class="card-title">What to Study</h5>
                      <p class="card-text">Explore qualifications and career paths</p>
                      <a href="#intrested_qualification_list" class="btn btn-outline-warning">Browse Courses</a>
                    </div>
                  </div>
                </div>                   
              </div>

              <!-- Recent Activity -->
              <div class="row mb-4">
                <div class="col-md-6 mb-4">
                  <div class="card h-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <h5 class="card-title m-0 me-2">Recent Activity</h5>
                      <div class="dropdown">
                        <button class="btn p-0" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <i class="bx bx-dots-vertical-rounded"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                          <a class="dropdown-item" href="javascript:void(0);">View All</a>
                        </div>
                      </div>
                    </div>
                    <div class="card-body">
                      <ul class="p-0 m-0">
                        <?php foreach($recent_activities as $activity): ?>
                        <li class="d-flex mb-4 pb-1">
                          <div class="avatar flex-shrink-0 me-3">
                            <span class="avatar-initial rounded bg-label-secondary">
                              <i class="bx <?php echo $activity['icon'] ?>"></i>
                            </span>
                          </div>
                          <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                            <div class="me-2">
                              <h6 class="mb-0"><?php echo $activity['action'] ?></h6>
                              <small class="text-muted"><?php echo $activity['time'] ?></small>
                            </div>
                          </div>
                        </li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  </div>
                </div>
                
                <!-- Progress Overview -->
                <div class="col-md-6 mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <h5 class="card-title m-0 me-2">Profile Progress</h5>
                    </div>
                    <div class="card-body">
                      <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center">
                          <div class="avatar flex-shrink-0 me-3">
                            <span class="avatar-initial rounded bg-label-primary"><i class="bx bx-user"></i></span>
                          </div>
                          <div>
                            <h6 class="mb-0">Personal Information</h6>
                            <small class="text-muted">Basic details and contact</small>
                          </div>
                        </div>
                        <span class="badge bg-label-success">Complete</span>
                      </div>
                      <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center">
                          <div class="avatar flex-shrink-0 me-3">
                            <span class="avatar-initial rounded bg-label-info"><i class="bx bx-book"></i></span>
                          </div>
                          <div>
                            <h6 class="mb-0">Academic Information</h6>
                            <small class="text-muted">Education history and interests</small>
                          </div>
                        </div>
                        <span class="badge bg-label-success">Complete</span>
                      </div>
                      <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                          <div class="avatar flex-shrink-0 me-3">
                            <span class="avatar-initial rounded bg-label-warning"><i class="bx bx-cloud-upload"></i></span>
                          </div>
                          <div>
                            <h6 class="mb-0">Document Uploads</h6>
                            <small class="text-muted">Required supporting documents</small>
                          </div>
                        </div>
                        <span class="badge bg-label-<?php echo $number_of_uploaded_documents == 11 ? 'success' : 'warning' ?>">
                          <?php echo $number_of_uploaded_documents ?>/11
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
              <!-- My Applications Section -->
              <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4" id="my_applications">
                <div class="card">
                  <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title m-0 me-2">My Applications</h5>
                    <button class="btn btn-sm btn-primary">New Application</button>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-hover">
                        <thead>
                          <tr>
                            <th>Organization</th>
                            <th>Program</th>
                            <th>Date Applied</th>
                            <th>Status</th>
                            <th>Actions</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                          <tr>
                            <td colspan="5" class="text-center py-5">
                              <div class="d-flex flex-column align-items-center">
                                <i class="bx bx-file bx-lg text-muted mb-3"></i>
                                <p class="text-muted mb-2">No applications yet</p>
                                <small class="text-muted">Start exploring opportunities to apply</small>
                              </div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Institutions Section -->
              <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4" id="intrested_institutions_list">
                <!-- ... (keep the existing institutions code) ... -->
              </div>

              <!-- Qualifications Section -->
              <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4" id="intrested_qualification_list">
                <!-- ... (keep the existing qualifications code) ... -->
              </div>

            </div>
            <!-- / Content -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>
    <script src="assets/js/main.js"></script>

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <style>
    .learner-welcome-card {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        color: white;
        border: none;
    }
    
    .learner-welcome-card .text-primary {
        color: white !important;
    }
    
    .learner-welcome-card .btn-outline-secondary {
        color: white;
        border-color: white;
    }
    
    .learner-welcome-card .btn-outline-secondary:hover {
        background: white;
        color: #4361ee;
    }
    
    .action-card {
        transition: transform 0.2s, box-shadow 0.2s;
        border: none;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        height: 100%;
    }
    
    .action-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    }
    
    .avatar-initial {
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .bg-label-primary { background-color: rgba(67, 97, 238, 0.15) !important; color: #4361ee; }
    .bg-label-success { background-color: rgba(76, 201, 240, 0.15) !important; color: #4cc9f0; }
    .bg-label-info { background-color: rgba(56, 189, 248, 0.15) !important; color: #38bdf8; }
    .bg-label-warning { background-color: rgba(250, 204, 21, 0.15) !important; color: #facc15; }
    </style>
  </body>
</html>