<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
    }
}

$company_name = str_replace(' ', '+', trim($db_company_name));

// Fetch dashboard stats for reporting
$api_url = $APIBASE."users/users_exec.php?action=view_corporate_dashboard&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$dashboardStats = json_decode($response);

if($dashboardStats && count($dashboardStats) > 0){
    foreach($dashboardStats as $row) {
        $total_administrators = $row->total_administrators;
        $total_beneficiaries = $row->total_beneficiaries;
        $total_transactions = $row->total_transactions;
    }
}

// Fetch beneficiaries for demographic reports
$api_url = $APIBASE."users/users_exec.php?action=list_bursary_recepients&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$beneficiaries = json_decode($response);

// Fetch transactions for financial reports
$api_url = $APIBASE."users/users_exec.php?action=list_corporate_bursary_payments&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$transactions = json_decode($response);

// Calculate demographic statistics
$gender_stats = ['Male' => 0, 'Female' => 0];
$race_stats = ['African' => 0, 'Coloured' => 0, 'Indian' => 0, 'White' => 0, 'Other' => 0];
$province_stats = [];
$disability_stats = ['Yes' => 0, 'No' => 0];

if($beneficiaries && count($beneficiaries) > 0) {
    foreach($beneficiaries as $beneficiary) {
        // Gender stats
        if(isset($beneficiary->gender)) {
            $gender = $beneficiary->gender;
            if(isset($gender_stats[$gender])) {
                $gender_stats[$gender]++;
            } else {
                $gender_stats['Other']++;
            }
        }
        
        // Race stats
        if(isset($beneficiary->race)) {
            $race = $beneficiary->race;
            if(isset($race_stats[$race])) {
                $race_stats[$race]++;
            } else {
                $race_stats['Other']++;
            }
        }
        
        // Province stats
        if(isset($beneficiary->province)) {
            $province = $beneficiary->province;
            if(isset($province_stats[$province])) {
                $province_stats[$province]++;
            } else {
                $province_stats[$province] = 1;
            }
        }
        
        // Disability stats
        if(isset($beneficiary->disability)) {
            $disability = $beneficiary->disability;
            if($disability == 'Yes') {
                $disability_stats['Yes']++;
            } else {
                $disability_stats['No']++;
            }
        }
    }
}

// Calculate financial statistics
$financial_stats = [];
$yearly_totals = [];
$trunche_totals = ['1' => 0, '2' => 0, '3' => 0, '4' => 0];

if($transactions && count($transactions) > 0) {
    foreach($transactions as $transaction) {
        $year = $transaction->year;
        $trunche = $transaction->trunche;
        $amount = $transaction->amount;
        
        // Yearly totals
        if(isset($yearly_totals[$year])) {
            $yearly_totals[$year] += $amount;
        } else {
            $yearly_totals[$year] = $amount;
        }
        
        // Trunche totals
        if(isset($trunche_totals[$trunche])) {
            $trunche_totals[$trunche] += $amount;
        }
    }
    
    // Prepare data for charts
    $financial_stats['years'] = array_keys($yearly_totals);
    $financial_stats['yearly_amounts'] = array_values($yearly_totals);
    $financial_stats['trunches'] = array_keys($trunche_totals);
    $financial_stats['trunche_amounts'] = array_values($trunche_totals);
}

// Handle report generation
if(isset($_POST['generate_report'])) {
    $report_type = $_POST['report_type'];
    $report_format = $_POST['report_format'];
    $date_range = $_POST['date_range'];
    
    // In a real implementation, this would generate and download the report
    // For now, we'll just show a success message
    $report_success = "Report generated successfully!";
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search reports..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Reports & Analytics</h3>
                                    <p class="mb-0">Generate comprehensive reports and analytics for <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_dashboard.php?id=<?php echo $encrypted_id ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Alert Messages -->
            <?php if(isset($report_success)): ?>
            <div class="alert alert-success alert-dismissible mb-4" role="alert">
                <i class="bx bx-check-circle me-2"></i> <?php echo $report_success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <!-- /Alert Messages -->

            <!-- Report Generation Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Generate Reports</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="report_type" class="form-label">Report Type</label>
                                        <select class="form-select" id="report_type" name="report_type" required>
                                            <option value="">Select report type</option>
                                            <option value="financial">Financial Report</option>
                                            <option value="demographic">Demographic Report</option>
                                            <option value="academic">Academic Performance Report</option>
                                            <option value="comprehensive">Comprehensive Bursary Report</option>
                                            <option value="administrative">Administrative Report</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="report_format" class="form-label">Format</label>
                                        <select class="form-select" id="report_format" name="report_format" required>
                                            <option value="">Select format</option>
                                            <option value="pdf">PDF</option>
                                            <option value="excel">Excel</option>
                                            <option value="csv">CSV</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="date_range" class="form-label">Date Range</label>
                                        <select class="form-select" id="date_range" name="date_range" required>
                                            <option value="">Select date range</option>
                                            <option value="current_year">Current Year</option>
                                            <option value="last_year">Last Year</option>
                                            <option value="last_quarter">Last Quarter</option>
                                            <option value="last_month">Last Month</option>
                                            <option value="custom">Custom Range</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2 mb-3 d-flex align-items-end">
                                        <button type="submit" name="generate_report" class="btn btn-primary w-100">
                                            <i class="bx bx-download me-1"></i> Generate
                                        </button>
                                    </div>
                                </div>
                                <div class="row" id="customDateRange" style="display: none;">
                                    <div class="col-md-4 mb-3">
                                        <label for="start_date" class="form-label">Start Date</label>
                                        <input type="date" class="form-control" id="start_date" name="start_date">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="end_date" class="form-label">End Date</label>
                                        <input type="date" class="form-control" id="end_date" name="end_date">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Report Generation Section -->

            <!-- Analytics Dashboard -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Program Analytics</h5>
                            <span class="badge bg-label-primary">Real-time Data</span>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Program Overview -->
                                <div class="col-md-3 mb-4">
                                    <div class="card bg-label-primary">
                                        <div class="card-body text-center">
                                            <h2 class="mb-1"><?php echo $total_beneficiaries; ?></h2>
                                            <p class="mb-0">Total Beneficiaries</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-4">
                                    <div class="card bg-label-success">
                                        <div class="card-body text-center">
                                            <h2 class="mb-1"><?php echo $total_transactions; ?></h2>
                                            <p class="mb-0">Total Transactions</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-4">
                                    <div class="card bg-label-info">
                                        <div class="card-body text-center">
                                            <h2 class="mb-1"><?php echo $total_administrators; ?></h2>
                                            <p class="mb-0">Administrators</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-4">
                                    <div class="card bg-label-warning">
                                        <div class="card-body text-center">
                                            <h2 class="mb-1">R<?php echo number_format(array_sum($yearly_totals), 2); ?></h2>
                                            <p class="mb-0">Total Funding</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Analytics Dashboard -->

            <!-- Demographic Reports Section -->
            <div class="row mb-4">
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Gender Distribution</h5>
                        </div>
                        <div class="card-body">
                            <div id="genderChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Race Distribution</h5>
                        </div>
                        <div class="card-body">
                            <div id="raceChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Province Distribution</h5>
                        </div>
                        <div class="card-body">
                            <div id="provinceChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Disability Status</h5>
                        </div>
                        <div class="card-body">
                            <div id="disabilityChart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Demographic Reports Section -->

            <!-- Financial Reports Section -->
            <div class="row mb-4">
                <div class="col-md-8 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Yearly Funding Trends</h5>
                        </div>
                        <div class="card-body">
                            <div id="yearlyTrendsChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Trunche Distribution</h5>
                        </div>
                        <div class="card-body">
                            <div id="truncheChart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Financial Reports Section -->

            <!-- Academic Reports Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Academic Performance</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-trending-up bx-lg text-primary mb-3"></i>
                                            <h5>Performance Trends</h5>
                                            <p class="text-muted">View academic performance trends over time</p>
                                            <button class="btn btn-outline-primary">View Report</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-bar-chart-alt bx-lg text-success mb-3"></i>
                                            <h5>Subject Analysis</h5>
                                            <p class="text-muted">Analyze performance by subject area</p>
                                            <button class="btn btn-outline-success">View Analysis</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-graduation bx-lg text-info mb-3"></i>
                                            <h5>Graduation Rates</h5>
                                            <p class="text-muted">Track graduation and completion rates</p>
                                            <button class="btn btn-outline-info">View Rates</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-award bx-lg text-warning mb-3"></i>
                                            <h5>Achievement Reports</h5>
                                            <p class="text-muted">View student achievements and awards</p>
                                            <button class="btn btn-outline-warning">View Report</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Academic Reports Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}

.bg-label-primary { background-color: rgba(105, 108, 255, 0.16); color: #696cff; }
.bg-label-success { background-color: rgba(102, 212, 79, 0.16); color: #66d44f; }
.bg-label-info { background-color: rgba(3, 195, 236, 0.16); color: #03c3ec; }
.bg-label-warning { background-color: rgba(255, 171, 0, 0.16); color: #ffab00; }
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- ApexCharts -->
<script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Show/hide custom date range
    document.getElementById('date_range').addEventListener('change', function() {
        if(this.value === 'custom') {
            document.getElementById('customDateRange').style.display = 'flex';
        } else {
            document.getElementById('customDateRange').style.display = 'none';
        }
    });

    // Gender Distribution Chart
    var genderOptions = {
        series: <?php echo json_encode(array_values($gender_stats)); ?>,
        chart: {
            type: 'donut',
            height: 350
        },
        labels: <?php echo json_encode(array_keys($gender_stats)); ?>,
        colors: ['#696cff', '#ffab00', '#03c3ec'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    var genderChart = new ApexCharts(document.querySelector("#genderChart"), genderOptions);
    genderChart.render();

    // Race Distribution Chart
    var raceOptions = {
        series: <?php echo json_encode(array_values($race_stats)); ?>,
        chart: {
            type: 'pie',
            height: 350
        },
        labels: <?php echo json_encode(array_keys($race_stats)); ?>,
        colors: ['#696cff', '#ffab00', '#03c3ec', '#66d44f', '#e83e8c'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    var raceChart = new ApexCharts(document.querySelector("#raceChart"), raceOptions);
    raceChart.render();

    // Province Distribution Chart
    var provinceOptions = {
        series: [{
            data: <?php echo json_encode(array_values($province_stats)); ?>
        }],
        chart: {
            type: 'bar',
            height: 350
        },
        plotOptions: {
            bar: {
                borderRadius: 4,
                horizontal: true,
            }
        },
        dataLabels: {
            enabled: false
        },
        xaxis: {
            categories: <?php echo json_encode(array_keys($province_stats)); ?>,
        },
        colors: ['#696cff']
    };

    var provinceChart = new ApexCharts(document.querySelector("#provinceChart"), provinceOptions);
    provinceChart.render();

    // Disability Status Chart
    var disabilityOptions = {
        series: <?php echo json_encode(array_values($disability_stats)); ?>,
        chart: {
            type: 'radialBar',
            height: 350
        },
        plotOptions: {
            radialBar: {
                dataLabels: {
                    name: {
                        fontSize: '22px',
                    },
                    value: {
                        fontSize: '16px',
                    },
                    total: {
                        show: true,
                        label: 'Total',
                        formatter: function (w) {
                            return <?php echo array_sum($disability_stats); ?>;
                        }
                    }
                }
            }
        },
        labels: <?php echo json_encode(array_keys($disability_stats)); ?>,
        colors: ['#66d44f', '#ffab00']
    };

    var disabilityChart = new ApexCharts(document.querySelector("#disabilityChart"), disabilityOptions);
    disabilityChart.render();

    // Yearly Trends Chart
    var yearlyOptions = {
        series: [{
            name: 'Funding Amount',
            data: <?php echo isset($financial_stats['yearly_amounts']) ? json_encode($financial_stats['yearly_amounts']) : '[]'; ?>
        }],
        chart: {
            type: 'area',
            height: 350,
            zoom: {
                enabled: false
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'straight'
        },
        title: {
            text: 'Yearly Funding Trends',
            align: 'left'
        },
        labels: <?php echo isset($financial_stats['years']) ? json_encode($financial_stats['years']) : '[]'; ?>,
        xaxis: {
            type: 'category',
        },
        yaxis: {
            opposite: true
        },
        legend: {
            horizontalAlign: 'left'
        },
        colors: ['#696cff']
    };

    var yearlyChart = new ApexCharts(document.querySelector("#yearlyTrendsChart"), yearlyOptions);
    yearlyChart.render();

    // Trunche Distribution Chart
    var truncheOptions = {
        series: <?php echo isset($financial_stats['trunche_amounts']) ? json_encode($financial_stats['trunche_amounts']) : '[]'; ?>,
        chart: {
            type: 'polarArea',
            height: 350
        },
        labels: <?php echo isset($financial_stats['trunches']) ? json_encode($financial_stats['trunches']) : '["1", "2", "3", "4"]'; ?>,
        fill: {
            opacity: 0.8
        },
        stroke: {
            width: 1,
            colors: undefined
        },
        yaxis: {
            show: false
        },
        legend: {
            position: 'bottom'
        },
        plotOptions: {
            polarArea: {
                rings: {
                    strokeWidth: 0
                },
                spokes: {
                    strokeWidth: 0
                },
            }
        },
        theme: {
            monochrome: {
                enabled: true,
                shadeTo: 'light',
                shadeIntensity: 0.6,
                color: '#696cff'
            }
        }
    };

    var truncheChart = new ApexCharts(document.querySelector("#truncheChart"), truncheOptions);
    truncheChart.render();
});
</script>
</body>
</html>