<?php
include('partials/_corporate_header.php');

// Fetch bursaries for this company
$api_url = $APIBASE."users/users_exec.php?action=get_bursaries_by_funder&funder=".urlencode($db_company_name);
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$bursaries = json_decode($response);
?>

<div class="layout-page">
    <!-- Navbar -->
    
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Manage Bursary Programs</h3>
                                    <p class="mb-0">View and manage bursary programs for <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_add_bursary.php?id=<?php echo toURL(rand()) ?>" class="btn btn-primary">
                                        <i class="bx bx-plus me-1"></i> Add New Bursary
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Bursaries List -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Bursary Programs</h5>
                            <div class="d-flex">
                                <input type="text" class="form-control form-control-sm me-2" placeholder="Search bursaries..." id="searchBursaries">
                                <button class="btn btn-sm btn-outline-secondary">
                                    <i class="bx bx-filter me-1"></i> Filter
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Program Name</th>
                                            <th>End Date</th>
                                            <th>Funding</th>
                                            <th>Field of Study</th>
                                            <th>Status</th>
                                            <th>Applications</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($bursaries && count($bursaries) > 0): ?>
                                            <?php foreach($bursaries as $bursary): 
                                                $end_date = new DateTime($bursary->application_end_date);
                                                $today = new DateTime();
                                                $is_active = $end_date >= $today;
                                                $status_class = $is_active ? 'success' : 'secondary';
                                            ?>
                                                <tr>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <span class="avatar-initial rounded-circle bg-label-primary">
                                                                    <i class="bx bx-money"></i>
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $bursary->project_name; ?></div>
                                                                <small class="text-muted"><?php echo $bursary->funder_name; ?></small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo date('M j, Y', strtotime($bursary->application_end_date)); ?></td>
                                                    <td>
                                                        <?php if($bursary->funding_amount): ?>
                                                            R<?php echo number_format($bursary->funding_amount, 2); ?>
                                                        <?php else: ?>
                                                            <span class="text-muted">Not specified</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo $bursary->field_of_study ?: 'N/A'; ?></td>
                                                    <td>
                                                        <span class="badge bg-label-<?php echo $status_class; ?>">
                                                            <?php echo $is_active ? 'Active' : 'Expired'; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-label-info">0 Applied</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                                <i class="bx bx-dots-vertical-rounded"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item" href="corporate_edit_bursary.php?id=<?php echo $bursary->bursary_id; ?>">
                                                                    <i class="bx bx-edit me-1"></i> Edit
                                                                </a>
                                                                <a class="dropdown-item" href="#">
                                                                    <i class="bx bx-show me-1"></i> View Details
                                                                </a>
                                                                <a class="dropdown-item" href="#">
                                                                    <i class="bx bx-list-check me-1"></i> View Applications
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a class="dropdown-item text-danger" href="#" onclick="deleteBursary(<?php echo $bursary->bursary_id; ?>)">
                                                                    <i class="bx bx-trash me-1"></i> Delete
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="7" class="text-center py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-money bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No bursary programs found</p>
                                                        <small class="text-muted">Create your first bursary program to get started</small>
                                                        <a href="corporate_add_bursary.php?id=<?php echo toURL(rand()) ?>" class="btn btn-primary mt-3">
                                                            <i class="bx bx-plus me-1"></i> Add Bursary Program
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Bursaries List -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Delete Confirmation Script -->
<script>
function deleteBursary(id) {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch('<?php echo $APIBASE; ?>users/users_exec.php?action=delete_bursary_program&id=' + id)
                .then(response => response.json())
                .then(data => {
                    if (data[0].success === '1') {
                        Swal.fire(
                            'Deleted!',
                            'Bursary program has been deleted.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error!',
                            'Failed to delete bursary program.',
                            'error'
                        );
                    }
                });
        }
    });
}
</script>

<?php include('partials/_corporate_footer.php'); ?>