<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
    }
}

$company_name = str_replace(' ', '+', trim($db_company_name));

// Fetch financial transactions
$api_url = $APIBASE."users/users_exec.php?action=list_corporate_bursary_payments&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$transactions = json_decode($response);

// Fetch beneficiaries for payment processing
$api_url = $APIBASE."users/users_exec.php?action=list_bursary_recepients&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$beneficiaries = json_decode($response);

// Calculate financial statistics
$total_payments = 0;
$current_year_payments = 0;
$pending_payments = 0;

if($transactions && count($transactions) > 0) {
    foreach($transactions as $transaction) {
        $total_payments += $transaction->amount;
        
        // Check if transaction is from current year
        if(date('Y', strtotime($transaction->created_date)) == date('Y')) {
            $current_year_payments += $transaction->amount;
        }
        
        // Check if transaction is pending (you might need to add a status field to your transactions)
        // This is a placeholder logic
        if($transaction->status == 'pending') {
            $pending_payments += $transaction->amount;
        }
    }
}

// Handle search functionality
$search_results = [];
if(isset($_POST['search_transactions'])) {
    $search_term = $_POST['search_term'];
    $search_field = $_POST['search_field'];
    
    if(!empty($search_term)) {
        foreach($transactions as $transaction) {
            $field_value = '';
            switch($search_field) {
                case 'student':
                    $field_value = $transaction->firstname . ' ' . $transaction->surname;
                    break;
                case 'email':
                    $field_value = $transaction->email;
                    break;
                case 'year':
                    $field_value = $transaction->year;
                    break;
                case 'trunche':
                    $field_value = $transaction->trunche;
                    break;
                default:
                    $field_value = $transaction->firstname . ' ' . $transaction->surname;
            }
            
            if(stripos($field_value, $search_term) !== false) {
                $search_results[] = $transaction;
            }
        }
    } else {
        $search_results = $transactions;
    }
} else {
    $search_results = $transactions;
}

// Handle filter functionality
if(isset($_POST['filter_transactions'])) {
    $filter_year = $_POST['filter_year'];
    $filter_trunche = $_POST['filter_trunche'];
    $filter_status = $_POST['filter_status'];
    
    $temp_results = $search_results;
    $search_results = [];
    
    foreach($temp_results as $transaction) {
        $match = true;
        
        if(!empty($filter_year) && $filter_year != 'all' && $transaction->year != $filter_year) {
            $match = false;
        }
        
        if(!empty($filter_trunche) && $filter_trunche != 'all' && $transaction->trunche != $filter_trunche) {
            $match = false;
        }
        
        if(!empty($filter_status) && $filter_status != 'all') {
            // This is a placeholder - you'll need to add status field to your transactions
            // For now, we'll assume all transactions are completed
            if($filter_status == 'pending') {
                $match = false;
            }
        }
        
        if($match) {
            $search_results[] = $transaction;
        }
    }
}

// Handle add payment form submission
if(isset($_POST['add_payment'])) {
    $email = $_POST['email'];
    $year = $_POST['year'];
    $trunche = $_POST['trunche'];
    $amount = $_POST['amount'];
    
    // Get beneficiary details
    $beneficiary_details = null;
    foreach($beneficiaries as $beneficiary) {
        if($beneficiary->email == $email) {
            $beneficiary_details = $beneficiary;
            break;
        }
    }
    
    if($beneficiary_details) {
        // Add new payment
        $api_url = $APIBASE."users/users_exec.php?action=add_bursary_payment";
        $client = curl_init($api_url);
        $form_data = array(
            'corporate' => $db_company_name,
            'firstname' => $beneficiary_details->firstname,
            'surname' => $beneficiary_details->surname,
            'email' => $email,
            'whatsapp' => $beneficiary_details->whatsapp,
            'alt_number' => $beneficiary_details->alt_number,
            'year' => $year,
            'trunche' => $trunche,
            'amount' => $amount
        );
        
        curl_setopt($client, CURLOPT_POST, true);
        curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        $result = json_decode($response);
        
        if($result && count($result) > 0 && $result[0]->success == '1') {
            $add_success = "Payment processed successfully.";
            // Refresh the transactions list
            $api_url = $APIBASE."users/users_exec.php?action=list_corporate_bursary_payments&corporate=".$company_name."";
            $client = curl_init($api_url);
            curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($client);
            $transactions = json_decode($response);
            $search_results = $transactions;
            
            // Update statistics
            $total_payments += $amount;
            if($year == date('Y')) {
                $current_year_payments += $amount;
            }
        } else {
            $add_error = "Failed to process payment. Please try again.";
        }
    } else {
        $add_error = "Beneficiary not found.";
    }
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search transactions..."
                        aria-label="Search..."
                        id="searchInput"
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Financial Management</h3>
                                    <p class="mb-0">Manage bursary payments and financial transactions for <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_dashboard.php?id=<?php echo $encrypted_id ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPaymentModal">
                                        <i class="bx bx-credit-card me-1"></i> Process Payment
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Alert Messages -->
            <?php if(isset($add_success)): ?>
            <div class="alert alert-success alert-dismissible mb-4" role="alert">
                <i class="bx bx-check-circle me-2"></i> <?php echo $add_success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <?php if(isset($add_error)): ?>
            <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                <i class="bx bx-error-circle me-2"></i> <?php echo $add_error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <!-- /Alert Messages -->

            <!-- Financial Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total Payments</h6>
                                    <h4 class="stat-value">R<?php echo number_format($total_payments, 2); ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 12%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-money bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Current Year</h6>
                                    <h4 class="stat-value">R<?php echo number_format($current_year_payments, 2); ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 8%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-calendar bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Pending Payments</h6>
                                    <h4 class="stat-value">R<?php echo number_format($pending_payments, 2); ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-up-arrow-alt"></i> 15%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-time bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total Transactions</h6>
                                    <h4 class="stat-value"><?php echo count($transactions); ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 5%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-credit-card bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Financial Stats Cards -->

            <!-- Search and Filter Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="search_term" class="form-label">Search Transactions</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="search_term" name="search_term" placeholder="Search transactions..." value="<?php echo isset($_POST['search_term']) ? $_POST['search_term'] : ''; ?>">
                                            <select class="form-select" name="search_field" style="max-width: 130px;">
                                                <option value="student" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'student') ? 'selected' : ''; ?>>Student</option>
                                                <option value="email" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'email') ? 'selected' : ''; ?>>Email</option>
                                                <option value="year" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'year') ? 'selected' : ''; ?>>Year</option>
                                                <option value="trunche" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'trunche') ? 'selected' : ''; ?>>Trunche</option>
                                            </select>
                                            <button type="submit" name="search_transactions" class="btn btn-primary">Search</button>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="row">
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_year" class="form-label">Year</label>
                                                <select class="form-select" id="filter_year" name="filter_year">
                                                    <option value="all" <?php echo (isset($_POST['filter_year']) && $_POST['filter_year'] == 'all') ? 'selected' : ''; ?>>All Years</option>
                                                    <?php
                                                    $current_year = date('Y');
                                                    for($i = $current_year; $i >= $current_year - 5; $i--) {
                                                        echo '<option value="'.$i.'" '.((isset($_POST['filter_year']) && $_POST['filter_year'] == $i) ? 'selected' : '').'>'.$i.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_trunche" class="form-label">Trunche</label>
                                                <select class="form-select" id="filter_trunche" name="filter_trunche">
                                                    <option value="all" <?php echo (isset($_POST['filter_trunche']) && $_POST['filter_trunche'] == 'all') ? 'selected' : ''; ?>>All Trunches</option>
                                                    <option value="1" <?php echo (isset($_POST['filter_trunche']) && $_POST['filter_trunche'] == '1') ? 'selected' : ''; ?>>Trunche 1</option>
                                                    <option value="2" <?php echo (isset($_POST['filter_trunche']) && $_POST['filter_trunche'] == '2') ? 'selected' : ''; ?>>Trunche 2</option>
                                                    <option value="3" <?php echo (isset($_POST['filter_trunche']) && $_POST['filter_trunche'] == '3') ? 'selected' : ''; ?>>Trunche 3</option>
                                                    <option value="4" <?php echo (isset($_POST['filter_trunche']) && $_POST['filter_trunche'] == '4') ? 'selected' : ''; ?>>Trunche 4</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_status" class="form-label">Status</label>
                                                <select class="form-select" id="filter_status" name="filter_status">
                                                    <option value="all" <?php echo (isset($_POST['filter_status']) && $_POST['filter_status'] == 'all') ? 'selected' : ''; ?>>All Status</option>
                                                    <option value="completed" <?php echo (isset($_POST['filter_status']) && $_POST['filter_status'] == 'completed') ? 'selected' : ''; ?>>Completed</option>
                                                    <option value="pending" <?php echo (isset($_POST['filter_status']) && $_POST['filter_status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3 d-flex align-items-end">
                                                <button type="submit" name="filter_transactions" class="btn btn-outline-primary w-100">Apply Filters</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Search and Filter Section -->

            <!-- Transactions Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Financial Transactions - <?php echo $db_company_name ?></h5>
                            <span class="badge bg-label-info">R<?php echo number_format($total_payments, 2); ?> Total</span>
                        </div>
                        <div class="card-body">
                            <?php if(count($search_results) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover" id="transactionsTable">
                                    <thead>
                                        <tr>
                                            <th>Transaction Date</th>
                                            <th>Year</th>
                                            <th>Trunche</th>
                                            <th>Student</th>
                                            <th>Whatsapp</th>
                                            <th>Email</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php foreach($search_results as $row): ?>
                                            <tr>
                                                <td><?php echo date('M j, Y', strtotime($row->created_date)) ?></td>
                                                <td><?php echo $row->year ?></td>
                                                <td>
                                                    <span class="badge bg-label-primary"><?php echo $row->trunche ?></span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar avatar-sm me-3">
                                                            <?php 
                                                            $avatar = "assets/img/avatars/blackboy.png"; // default
                                                            ?>
                                                            <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                        </div>
                                                        <div>
                                                            <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                            <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo $row->whatsapp ?></td>
                                                <td><?php echo $row->email ?></td>
                                                <td>
                                                    <strong>R<?php echo number_format($row->amount, 2) ?></strong>
                                                </td>
                                                <td>
                                                    <span class="badge bg-label-success">Completed</span>
                                                </td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                            <i class="bx bx-dots-vertical-rounded"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#viewReceiptModal" data-id="<?php echo $row->finance_id ?>">
                                                                <i class="bx bx-receipt me-1"></i> View Receipt
                                                            </a>
                                                            <a class="dropdown-item" href="#">
                                                                <i class="bx bx-download me-1"></i> Download Invoice
                                                            </a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-warning" href="#">
                                                                <i class="bx bx-edit me-1"></i> Edit Payment
                                                            </a>
                                                            <a class="dropdown-item text-danger" href="#">
                                                                <i class="bx bx-trash me-1"></i> Delete Payment
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bx bx-credit-card bx-lg text-muted mb-3"></i>
                                    <p class="text-muted mb-2">No transactions found</p>
                                    <small class="text-muted">Try processing a payment using the button above</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Transactions Section -->

            <!-- Financial Reports Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Financial Reports</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-file bx-lg text-primary mb-3"></i>
                                            <h5>Annual Report</h5>
                                            <p class="text-muted">Generate comprehensive annual financial report</p>
                                            <button class="btn btn-outline-primary">Generate Report</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-pie-chart-alt bx-lg text-success mb-3"></i>
                                            <h5>Expense Analysis</h5>
                                            <p class="text-muted">View detailed expense analysis by category</p>
                                            <button class="btn btn-outline-success">View Analysis</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-trending-up bx-lg text-info mb-3"></i>
                                            <h5>Payment Trends</h5>
                                            <p class="text-muted">Analyze payment trends over time</p>
                                            <button class="btn btn-outline-info">View Trends</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Financial Reports Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Add Payment Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Process New Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="email" class="form-label">Select Beneficiary</label>
                        <select class="form-select" id="email" name="email" required>
                            <option value="">Select a beneficiary</option>
                            <?php if($beneficiaries && count($beneficiaries) > 0): ?>
                                <?php foreach($beneficiaries as $beneficiary): ?>
                                    <option value="<?php echo $beneficiary->email; ?>"><?php echo $beneficiary->firstname . ' ' . $beneficiary->surname . ' (' . $beneficiary->email . ')'; ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="year" class="form-label">Year</label>
                            <select class="form-select" id="year" name="year" required>
                                <option value="">Select year</option>
                                <?php
                                $current_year = date('Y');
                                for($i = $current_year; $i >= $current_year - 5; $i--) {
                                    echo '<option value="'.$i.'">'.$i.'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="trunche" class="form-label">Trunche</label>
                            <select class="form-select" id="trunche" name="trunche" required>
                                <option value="">Select trunche</option>
                                <option value="1">Trunche 1</option>
                                <option value="2">Trunche 2</option>
                                <option value="3">Trunche 3</option>
                                <option value="4">Trunche 4</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount (ZAR)</label>
                        <input type="number" class="form-control" id="amount" name="amount" min="0" step="0.01" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_payment" class="btn btn-primary">Process Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Receipt Modal -->
<div class="modal fade" id="viewReceiptModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Payment Receipt</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="receipt-container">
                    <div class="receipt-header text-center mb-4">
                        <h4><?php echo $db_company_name; ?></h4>
                        <p class="text-muted">Bursary Payment Receipt</p>
                    </div>
                    <div class="receipt-details">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Receipt Number:</strong> <span id="receiptNumber">--</span>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <strong>Date:</strong> <span id="receiptDate">--</span>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col-12">
                                <strong>Student:</strong> <span id="receiptStudent">--</span><br>
                                <strong>Email:</strong> <span id="receiptEmail">--</span><br>
                                <strong>Year:</strong> <span id="receiptYear">--</span><br>
                                <strong>Trunche:</strong> <span id="receiptTrunche">--</span>
                            </div>
                        </div>
                        <div class="receipt-amount text-center py-3 bg-light rounded">
                            <h3 class="text-success">R<span id="receiptAmount">--</span></h3>
                            <p class="text-muted">Amount Paid</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="printReceiptBtn">Print Receipt</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}

.receipt-container {
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    padding: 1.5rem;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // View receipt modal handler
    var receiptModal = document.getElementById('viewReceiptModal');
    receiptModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var transactionId = button.getAttribute('data-id');
        
        // In a real implementation, you would fetch transaction details via AJAX
        // For now, we'll use placeholder data
        document.getElementById('receiptNumber').textContent = 'RC-' + transactionId;
        document.getElementById('receiptDate').textContent = new Date().toLocaleDateString();
        document.getElementById('receiptStudent').textContent = 'Student Name';
        document.getElementById('receiptEmail').textContent = 'student@example.com';
        document.getElementById('receiptYear').textContent = '2023';
        document.getElementById('receiptTrunche').textContent = '1';
        document.getElementById('receiptAmount').textContent = '5,000.00';
    });

    // Print receipt button handler
    document.getElementById('printReceiptBtn').addEventListener('click', function() {
        window.print();
    });

    // Search functionality
    document.getElementById('searchInput').addEventListener('keyup', function() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("transactionsTable");
        tr = table.getElementsByTagName("tr");

        for (i = 0; i < tr.length; i++) {
            td = tr[i].getElementsByTagName("td")[3]; // Search in the fourth column (Student)
            if (td) {
                txtValue = td.textContent || td.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    tr[i].style.display = "";
                } else {
                    tr[i].style.display = "none";
                }
            }       
        }
    });
});
</script>
</body>
</html>