<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
    }
}

$company_name = str_replace(' ', '+', trim($db_company_name));

// Fetch dashboard stats
$api_url = $APIBASE."users/users_exec.php?action=view_corporate_dashboard&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$dashboardStats = json_decode($response);

if($dashboardStats && count($dashboardStats) > 0){
    foreach($dashboardStats as $row) {
        $total_administrators = $row->total_administrators;
        $total_beneficiaries = $row->total_beneficiaries;
        $total_transactions = $row->total_transactions;
        $registrations_today = $row->registrations_today;
    }
}

// Fetch administrators
$api_url = $APIBASE."users/users_exec.php?action=list_corporates_users&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$administrators = json_decode($response);

// Fetch beneficiaries
$api_url = $APIBASE."users/users_exec.php?action=list_bursary_recepients&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$beneficiaries = json_decode($response);

// Fetch transactions
$api_url = $APIBASE."users/users_exec.php?action=list_corporate_bursary_payments&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$transactions = json_decode($response);

// Calculate financial statistics
$total_payments = 0;
$current_year_payments = 0;
$pending_payments = 0;
$yearly_totals = [];
$monthly_totals = array_fill(0, 12, 0); // Initialize monthly totals

if($transactions && count($transactions) > 0) {
    foreach($transactions as $transaction) {
        $total_payments += $transaction->amount;
        
        // Check if transaction is from current year
        if(date('Y', strtotime($transaction->created_date)) == date('Y')) {
            $current_year_payments += $transaction->amount;
            
            // Get month for monthly breakdown (0-11)
            $month = date('n', strtotime($transaction->created_date)) - 1;
            $monthly_totals[$month] += $transaction->amount;
        }
        
        // Yearly totals
        $year = $transaction->year;
        if(isset($yearly_totals[$year])) {
            $yearly_totals[$year] += $transaction->amount;
        } else {
            $yearly_totals[$year] = $transaction->amount;
        }
    }
}

// Calculate demographic statistics
$gender_stats = ['Male' => 0, 'Female' => 0];
$race_stats = ['African' => 0, 'Coloured' => 0, 'Indian' => 0, 'White' => 0, 'Other' => 0];

if($beneficiaries && count($beneficiaries) > 0) {
    foreach($beneficiaries as $beneficiary) {
        // Gender stats
        if(isset($beneficiary->gender)) {
            $gender = $beneficiary->gender;
            if(isset($gender_stats[$gender])) {
                $gender_stats[$gender]++;
            }
        }
        
        // Race stats
        if(isset($beneficiary->race)) {
            $race = $beneficiary->race;
            if(isset($race_stats[$race])) {
                $race_stats[$race]++;
            } else {
                $race_stats['Other']++;
            }
        }
    }
}

// Get recent transactions (last 5)
$recent_transactions = array_slice($transactions, 0, 5);

// Get recent beneficiaries (last 5)
$recent_beneficiaries = array_slice($beneficiaries, 0, 5);

// Calculate percentage change (for demo purposes)
$beneficiaries_change = 8; // Example percentage change
$transactions_change = 15; // Example percentage change
$funding_change = 5; // Example percentage change

// Prepare chart data
$monthly_labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
$monthly_data = $monthly_totals;

$yearly_labels = array_keys($yearly_totals);
$yearly_data = array_values($yearly_totals);

$gender_labels = array_keys($gender_stats);
$gender_data = array_values($gender_stats);

$race_labels = array_keys($race_stats);
$race_data = array_values($race_stats);
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search beneficiaries, administrators..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Welcome, <?php echo $db_company_name; ?>! 👋</h3>
                                    <p class="mb-0">Manage your bursary program, beneficiaries, and track financial transactions</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_add_admin.php?id=<?php echo $encrypted_id ?>" class="btn btn-primary">
                                        <i class="bx bx-user-plus me-1"></i> Add Administrator
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Administrators</h6>
                                    <h4 class="stat-value"><?php echo $total_administrators ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 12%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-user bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Beneficiaries</h6>
                                    <h4 class="stat-value"><?php echo $total_beneficiaries ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> <?php echo $beneficiaries_change ?>%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-user-check bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Transactions</h6>
                                    <h4 class="stat-value"><?php echo $total_transactions ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-up-arrow-alt"></i> <?php echo $transactions_change ?>%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-credit-card bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-3 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total Funding</h6>
                                    <h4 class="stat-value">R<?php echo number_format($total_payments, 2); ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> <?php echo $funding_change ?>%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-money bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Stats Cards -->

            <!-- Charts Section -->
            <div class="row mb-4">
                <!-- Monthly Funding Chart -->
                <div class="col-lg-6 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Monthly Funding Trends</h5>
                            <small class="text-muted">Current year funding distribution</small>
                        </div>
                        <div class="card-body">
                            <div id="monthlyFundingChart"></div>
                        </div>
                    </div>
                </div>

                <!-- Yearly Comparison Chart -->
                <div class="col-lg-6 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Yearly Comparison</h5>
                            <small class="text-muted">Funding across different years</small>
                        </div>
                        <div class="card-body">
                            <div id="yearlyComparisonChart"></div>
                        </div>
                    </div>
                </div>

                <!-- Demographic Charts -->
                <div class="col-lg-6 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Gender Distribution</h5>
                            <small class="text-muted">Beneficiaries by gender</small>
                        </div>
                        <div class="card-body">
                            <div id="genderDistributionChart"></div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Race Distribution</h5>
                            <small class="text-muted">Beneficiaries by race</small>
                        </div>
                        <div class="card-body">
                            <div id="raceDistributionChart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Charts Section -->

            <!-- Recent Activity Section -->
            <div class="row mb-4">
                <!-- Recent Transactions -->
                <div class="col-lg-12 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Recent Transactions</h5>
                            <a href="corporate_financials.php?id=<?php echo $encrypted_id ?>" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Student</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if($recent_transactions && count($recent_transactions) > 0): ?>
                                            <?php foreach($recent_transactions as $row): ?>
                                                <tr>
                                                    <td><?php echo date('M j', strtotime($row->created_date)) ?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-30 h-auto rounded-circle" />
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                                <small class="text-muted"><?php echo substr($row->email, 0, 8) ?>...</small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <strong>R<?php echo number_format($row->amount, 2) ?></strong>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-label-success">Completed</span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="4" align="center" class="py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-credit-card bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No transactions found</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Beneficiaries -->
                <div class="col-lg-12 col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Recent Beneficiaries</h5>
                            <a href="corporate_beneficiaries.php?id=<?php echo $encrypted_id ?>" class="btn btn-sm btn-outline-primary">View All</a>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Whatsapp</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if($recent_beneficiaries && count($recent_beneficiaries) > 0): ?>
                                            <?php foreach($recent_beneficiaries as $row): ?>
                                                <tr>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <?php 
                                                                $avatar = "assets/img/avatars/blackboy.png"; // default
                                                                if(isset($row->gender) && $row->gender == "Female") {
                                                                    $avatar = "assets/img/avatars/blackgirl.jpeg";
                                                                }
                                                                ?>
                                                                <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                                <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $row->email ?></td>
                                                    <td><?php echo $row->whatsapp ?></td>
                                                    <td>
                                                        <span class="badge bg-label-success">Active</span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="4" align="center" class="py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-user-check bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No beneficiaries found</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Recent Activity Section -->

            <!-- Quick Actions Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Quick Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 col-6 mb-4">
                                    <a href="corporate_add_admin.php?id=<?php echo $encrypted_id ?>" class="card action-card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-user-plus bx-lg text-primary mb-3"></i>
                                            <h6>Add Administrator</h6>
                                            <p class="text-muted small">Add new admin users</p>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-4">
                                    <a href="corporate_financials.php?id=<?php echo $encrypted_id ?>" class="card action-card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-credit-card bx-lg text-success mb-3"></i>
                                            <h6>Process Payment</h6>
                                            <p class="text-muted small">Process new payments</p>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-4">
                                    <a href="corporate_reports.php?id=<?php echo $encrypted_id ?>" class="card action-card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-bar-chart-alt bx-lg text-info mb-3"></i>
                                            <h6>Generate Reports</h6>
                                            <p class="text-muted small">Create financial reports</p>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-4">
                                    <a href="corporate_settings.php?id=<?php echo $encrypted_id ?>" class="card action-card">
                                        <div class="card-body text-center">
                                            <i class="bx bx-cog bx-lg text-warning mb-3"></i>
                                            <h6>Settings</h6>
                                            <p class="text-muted small">Manage preferences</p>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Quick Actions Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.action-card {
    transition: all 0.3s ease;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.action-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    text-decoration: none;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- ApexCharts -->
<script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Monthly Funding Chart
    var monthlyFundingOptions = {
        series: [{
            name: 'Funding Amount',
            data: <?php echo json_encode($monthly_data); ?>
        }],
        chart: {
            type: 'bar',
            height: 350,
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                borderRadius: 4,
                horizontal: false,
            }
        },
        dataLabels: {
            enabled: false
        },
        xaxis: {
            categories: <?php echo json_encode($monthly_labels); ?>,
        },
        colors: ['#696cff'],
        grid: {
            borderColor: '#f3f4f6',
        }
    };

    var monthlyFundingChart = new ApexCharts(document.querySelector("#monthlyFundingChart"), monthlyFundingOptions);
    monthlyFundingChart.render();

    // Yearly Comparison Chart
    var yearlyComparisonOptions = {
        series: [{
            name: 'Funding Amount',
            data: <?php echo json_encode($yearly_data); ?>
        }],
        chart: {
            type: 'bar',
            height: 350,
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                borderRadius: 4,
                horizontal: false,
            }
        },
        dataLabels: {
            enabled: false
        },
        xaxis: {
            categories: <?php echo json_encode($yearly_labels); ?>,
        },
        colors: ['#66d44f'],
        grid: {
            borderColor: '#f3f4f6',
        }
    };

    var yearlyComparisonChart = new ApexCharts(document.querySelector("#yearlyComparisonChart"), yearlyComparisonOptions);
    yearlyComparisonChart.render();

    // Gender Distribution Chart
    var genderDistributionOptions = {
        series: <?php echo json_encode($gender_data); ?>,
        chart: {
            type: 'donut',
            height: 350,
            toolbar: {
                show: false
            }
        },
        labels: <?php echo json_encode($gender_labels); ?>,
        colors: ['#696cff', '#ffab00'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    var genderDistributionChart = new ApexCharts(document.querySelector("#genderDistributionChart"), genderDistributionOptions);
    genderDistributionChart.render();

    // Race Distribution Chart
    var raceDistributionOptions = {
        series: <?php echo json_encode($race_data); ?>,
        chart: {
            type: 'pie',
            height: 350,
            toolbar: {
                show: false
            }
        },
        labels: <?php echo json_encode($race_labels); ?>,
        colors: ['#696cff', '#ffab00', '#03c3ec', '#66d44f', '#e83e8c'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    var raceDistributionChart = new ApexCharts(document.querySelector("#raceDistributionChart"), raceDistributionOptions);
    raceDistributionChart.render();
});
</script>
</body>
</html>