<?php
include('partials/_corporate_header.php');

// Get current page from URL or set to 1
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20; // Number of records per page
$offset = ($page - 1) * $limit;

// Fetch applications for this company's bursaries
$api_url = $APIBASE."users/users_exec.php?action=get_bursary_applications&company=".urlencode($db_company_name);
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$applications = json_decode($response);
$totalApplications = $applications ? count($applications) : 0;
$totalPages = ceil($totalApplications / $limit);
$applicationsPaginated = array_slice($applications, $offset, $limit);

// Fetch stats
$api_url = $APIBASE."users/users_exec.php?action=get_bursary_application_stats&company=".urlencode($db_company_name);
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$applicationStats = json_decode($response);

// Initialize stats with default values
$stats = [
    'total' => 0,
    'pending' => 0,
    'approved' => 0,
    'rejected' => 0,
    'shortlisted' => 0
];

if($applicationStats && count($applicationStats) > 0){
    $stats = (array)$applicationStats[0];
}
?>

<div class="layout-page">
    <!-- Navbar -->
    
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Bursary Applications</h3>
                                    <p class="mb-0">Manage and review applications for <?php echo $db_company_name; ?> bursary programs</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <div class="btn-group">
                                        <button class="btn btn-outline-primary">
                                            <i class="bx bx-export me-1"></i> Export
                                        </button>
                                        <button class="btn btn-primary">
                                            <i class="bx bx-filter me-1"></i> Filters
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total</h6>
                                    <h4 class="stat-value"><?php echo $stats['total']; ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-trending-up"></i> All</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-file bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Pending</h6>
                                    <h4 class="stat-value"><?php echo $stats['pending']; ?></h4>
                                    <span class="stat-change text-warning"><i class="bx bx-time"></i> Review</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-time bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Approved</h6>
                                    <h4 class="stat-value"><?php echo $stats['approved']; ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-check"></i> Accepted</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-check-circle bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Rejected</h6>
                                    <h4 class="stat-value"><?php echo $stats['rejected']; ?></h4>
                                    <span class="stat-change text-danger"><i class="bx bx-x"></i> Declined</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-danger p-2 rounded">
                                        <i class="bx bx-x-circle bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Shortlisted</h6>
                                    <h4 class="stat-value"><?php echo $stats['shortlisted']; ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-star"></i> Potential</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-star bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-xl-2 col-lg-4 col-md-6 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Conversion</h6>
                                    <h4 class="stat-value"><?php echo $stats['total'] > 0 ? round(($stats['approved'] / $stats['total']) * 100) : 0; ?>%</h4>
                                    <span class="stat-change text-success"><i class="bx bx-trending-up"></i> Rate</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-secondary p-2 rounded">
                                        <i class="bx bx-line-chart bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Stats Cards -->

            <!-- Applications List -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Bursary Applications</h5>
                            <div class="d-flex">
                                <select class="form-select form-select-sm me-2" id="statusFilter">
                                    <option value="">All Status</option>
                                    <option value="pending">Pending</option>
                                    <option value="approved">Approved</option>
                                    <option value="rejected">Rejected</option>
                                    <option value="shortlisted">Shortlisted</option>
                                </select>
                                <input type="text" class="form-control form-control-sm me-2" placeholder="Search applications..." id="searchApplications">
                                <button class="btn btn-sm btn-outline-secondary">
                                    <i class="bx bx-filter me-1"></i> Filter
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Applicant</th>
                                            <th>Bursary Program</th>
                                            <th>Applied Date</th>
                                            <th>Academic Score</th>
                                            <th>Financial Need</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if($applicationsPaginated && count($applicationsPaginated) > 0): ?>
                                            <?php foreach($applicationsPaginated as $application): 
                                                $status_class = '';
                                                $status_icon = '';
                                                switch($application->status) {
                                                    case 'approved':
                                                        $status_class = 'success';
                                                        $status_icon = 'bx-check';
                                                        break;
                                                    case 'rejected':
                                                        $status_class = 'danger';
                                                        $status_icon = 'bx-x';
                                                        break;
                                                    case 'shortlisted':
                                                        $status_class = 'info';
                                                        $status_icon = 'bx-star';
                                                        break;
                                                    default:
                                                        $status_class = 'warning';
                                                        $status_icon = 'bx-time';
                                                }
                                            ?>
                                                <tr>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar avatar-sm me-3">
                                                                <?php 
                                                                $avatar = "assets/img/avatars/blackboy.png"; // default
                                                                if(isset($application->gender) && $application->gender == "Female") {
                                                                    $avatar = "assets/img/avatars/blackgirl.jpeg";
                                                                }
                                                                ?>
                                                                <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                            </div>
                                                            <div>
                                                                <div class="fw-semibold"><?php echo $application->firstname.' '.$application->surname; ?></div>
                                                                <small class="text-muted"><?php echo $application->email; ?></small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="fw-semibold"><?php echo $application->project_name; ?></div>
                                                        <small class="text-muted"><?php echo $application->funder_name; ?></small>
                                                    </td>
                                                    <td><?php echo date('M j, Y', strtotime($application->application_date)); ?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="progress w-px-60 me-2" style="height: 6px;">
                                                                <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo $application->academic_score ?? 75; ?>%;" aria-valuenow="<?php echo $application->academic_score ?? 75; ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <small><?php echo $application->academic_score ?? 75; ?>%</small>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-label-<?php echo $application->financial_need == 'high' ? 'danger' : ($application->financial_need == 'medium' ? 'warning' : 'success'); ?>">
                                                            <?php echo ucfirst($application->financial_need ?? 'medium'); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-label-<?php echo $status_class; ?>">
                                                            <i class="bx <?php echo $status_icon; ?> me-1"></i>
                                                            <?php echo ucfirst($application->status); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                                <i class="bx bx-dots-vertical-rounded"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item" href="corporate_view_application.php?id=<?php echo $application->application_id; ?>">
                                                                    <i class="bx bx-show me-1"></i> View Details
                                                                </a>
                                                                <a class="dropdown-item" href="#">
                                                                    <i class="bx bx-download me-1"></i> Download Documents
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a class="dropdown-item text-success" href="#">
                                                                    <i class="bx bx-check me-1"></i> Approve
                                                                </a>
                                                                <a class="dropdown-item text-info" href="#">
                                                                    <i class="bx bx-star me-1"></i> Shortlist
                                                                </a>
                                                                <a class="dropdown-item text-danger" href="#">
                                                                    <i class="bx bx-x me-1"></i> Reject
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="7" align="center" class="py-4">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bx bx-file bx-lg text-muted mb-2"></i>
                                                        <p class="text-muted mb-0">No applications found</p>
                                                        <small class="text-muted">Applications will appear here once students apply to your bursaries</small>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <?php if($totalPages > 1): ?>
                            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3">
                                <div class="text-muted mb-2 mb-md-0">
                                    Showing <?php echo min($limit, count($applicationsPaginated)) ?> of <?php echo $totalApplications ?> applications
                                </div>
                                <div class="d-flex flex-column flex-md-row align-items-center">
                                    <nav aria-label="Page navigation" class="mb-2 mb-md-0">
                                        <ul class="pagination pagination-sm mb-0">
                                            <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page - 1; ?>" tabindex="-1">
                                                    <i class="bx bx-chevron-left"></i>
                                                </a>
                                            </li>
                                            
                                            <?php 
                                            // Show limited page numbers with ellipsis
                                            $startPage = max(1, $page - 2);
                                            $endPage = min($totalPages, $page + 2);
                                            
                                            if ($startPage > 1) {
                                                echo '<li class="page-item"><a class="page-link" href="?page=1">1</a></li>';
                                                if ($startPage > 2) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                            }
                                            
                                            for($i = $startPage; $i <= $endPage; $i++): ?>
                                                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; 
                                            
                                            if ($endPage < $totalPages) {
                                                if ($endPage < $totalPages - 1) {
                                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                                }
                                                echo '<li class="page-item"><a class="page-link" href="?page='.$totalPages.'">'.$totalPages.'</a></li>';
                                            }
                                            ?>
                                            
                                            <li class="page-item <?php echo $page >= $totalPages ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $page + 1; ?>">
                                                    <i class="bx bx-chevron-right"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <div class="text-muted ms-md-2">
                                        Page <?php echo $page; ?> of <?php echo $totalPages; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Applications List -->

            <!-- Recent Activity -->
            <div class="row">
                <div class="col-lg-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Recent Application Activity</h5>
                        </div>
                        <div class="card-body">
                            <ul class="timeline">
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-warning"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h6 class="mb-0">New Application Received</h6>
                                            <small class="text-muted">Today</small>
                                        </div>
                                        <p class="mb-2">Sarah Johnson applied for Engineering Bursary 2024</p>
                                        <div class="d-flex">
                                            <span class="badge bg-label-warning">Pending Review</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-success"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h6 class="mb-0">Application Approved</h6>
                                            <small class="text-muted">Yesterday</small>
                                        </div>
                                        <p class="mb-2">Michael Brown's application was approved</p>
                                        <div class="d-flex">
                                            <span class="badge bg-label-success">Approved</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-info"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h6 class="mb-0">Application Shortlisted</h6>
                                            <small class="text-muted">2 days ago</small>
                                        </div>
                                        <p class="mb-2">Lisa Smith's application was shortlisted for further review</p>
                                        <div class="d-flex">
                                            <span class="badge bg-label-info">Shortlisted</span>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Application Status Distribution</h5>
                            <div class="dropdown">
                                <button class="btn p-0" type="button" id="chartDropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="chartDropdown">
                                    <a class="dropdown-item" href="javascript:void(0);">Last 7 Days</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Last 30 Days</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Last 90 Days</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="applicationStatusChart" style="min-height: 300px;"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Recent Activity -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Chart JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Application Status Chart
    var statusChartOptions = {
        series: [{
            name: 'Applications',
            data: [
                <?php echo $stats['pending']; ?>,
                <?php echo $stats['approved']; ?>,
                <?php echo $stats['rejected']; ?>,
                <?php echo $stats['shortlisted']; ?>
            ]
        }],
        chart: {
            type: 'bar',
            height: 300,
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                borderRadius: 4,
                horizontal: true,
                distributed: true,
            }
        },
        dataLabels: {
            enabled: false
        },
        colors: ['#ffc107', '#28a745', '#dc3545', '#17a2b8'],
        xaxis: {
            categories: ['Pending', 'Approved', 'Rejected', 'Shortlisted'],
            labels: {
                formatter: function(val) {
                    return Math.round(val) + ' apps'
                }
            }
        },
        yaxis: {
            labels: {
                style: {
                    fontSize: '14px'
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return val + ' applications'
                }
            }
        }
    };

    var statusChart = new ApexCharts(document.querySelector("#applicationStatusChart"), statusChartOptions);
    statusChart.render();
});
</script>

<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.timeline {
    padding: 0;
    margin: 0;
    list-style: none;
}

.timeline-item {
    position: relative;
    padding-left: 2rem;
    border-left: 1px solid #e9ecef;
    margin-left: 0.5rem;
}

.timeline-point {
    position: absolute;
    left: -0.5rem;
    top: 0;
    width: 1rem;
    height: 1rem;
    border-radius: 50%;
    border: 2px solid;
}

.timeline-event {
    margin-bottom: 1.5rem;
}
</style>

<?php include('partials/_corporate_footer.php'); ?>