<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
    }
}

$company_name = str_replace(' ', '+', trim($db_company_name));

// Fetch beneficiaries
$api_url = $APIBASE."users/users_exec.php?action=list_bursary_recepients&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$beneficiaries = json_decode($response);

// Fetch beneficiary academic data
$beneficiary_academics = [];
if($beneficiaries && count($beneficiaries) > 0) {
    foreach($beneficiaries as $beneficiary) {
        $api_url = $APIBASE."users/users_exec.php?action=list_user_academics&email=".$beneficiary->email."";
        $client = curl_init($api_url);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        $academics = json_decode($response);
        
        if($academics && count($academics) > 0) {
            $beneficiary_academics[$beneficiary->email] = $academics[0];
        }
    }
}

// Handle search functionality
$search_results = [];
if(isset($_POST['search_beneficiaries'])) {
    $search_term = $_POST['search_term'];
    $search_field = $_POST['search_field'];
    
    if(!empty($search_term)) {
        foreach($beneficiaries as $beneficiary) {
            $field_value = '';
            switch($search_field) {
                case 'name':
                    $field_value = $beneficiary->firstname . ' ' . $beneficiary->surname;
                    break;
                case 'email':
                    $field_value = $beneficiary->email;
                    break;
                case 'whatsapp':
                    $field_value = $beneficiary->whatsapp;
                    break;
                case 'id_number':
                    $field_value = $beneficiary->id_number;
                    break;
                default:
                    $field_value = $beneficiary->firstname . ' ' . $beneficiary->surname;
            }
            
            if(stripos($field_value, $search_term) !== false) {
                $search_results[] = $beneficiary;
            }
        }
    } else {
        $search_results = $beneficiaries;
    }
} else {
    $search_results = $beneficiaries;
}

// Handle filter functionality
if(isset($_POST['filter_beneficiaries'])) {
    $filter_gender = $_POST['filter_gender'];
    $filter_race = $_POST['filter_race'];
    $filter_province = $_POST['filter_province'];
    
    $temp_results = $search_results;
    $search_results = [];
    
    foreach($temp_results as $beneficiary) {
        $match = true;
        
        if(!empty($filter_gender) && $filter_gender != 'all' && $beneficiary->gender != $filter_gender) {
            $match = false;
        }
        
        if(!empty($filter_race) && $filter_race != 'all' && $beneficiary->race != $filter_race) {
            $match = false;
        }
        
        if(!empty($filter_province) && $filter_province != 'all' && $beneficiary->province != $filter_province) {
            $match = false;
        }
        
        if($match) {
            $search_results[] = $beneficiary;
        }
    }
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search beneficiaries..."
                        aria-label="Search..."
                        id="searchInput"
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Beneficiaries Management</h3>
                                    <p class="mb-0">Manage all beneficiaries assigned to <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_dashboard.php?id=<?php echo $encrypted_id ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exportModal">
                                        <i class="bx bx-download me-1"></i> Export Data
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Search and Filter Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="search_term" class="form-label">Search</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="search_term" name="search_term" placeholder="Search beneficiaries..." value="<?php echo isset($_POST['search_term']) ? $_POST['search_term'] : ''; ?>">
                                            <select class="form-select" name="search_field" style="max-width: 130px;">
                                                <option value="name" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'name') ? 'selected' : ''; ?>>Name</option>
                                                <option value="email" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'email') ? 'selected' : ''; ?>>Email</option>
                                                <option value="whatsapp" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'whatsapp') ? 'selected' : ''; ?>>WhatsApp</option>
                                                <option value="id_number" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'id_number') ? 'selected' : ''; ?>>ID Number</option>
                                            </select>
                                            <button type="submit" name="search_beneficiaries" class="btn btn-primary">Search</button>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="row">
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_gender" class="form-label">Gender</label>
                                                <select class="form-select" id="filter_gender" name="filter_gender">
                                                    <option value="all" <?php echo (isset($_POST['filter_gender']) && $_POST['filter_gender'] == 'all') ? 'selected' : ''; ?>>All Genders</option>
                                                    <option value="Male" <?php echo (isset($_POST['filter_gender']) && $_POST['filter_gender'] == 'Male') ? 'selected' : ''; ?>>Male</option>
                                                    <option value="Female" <?php echo (isset($_POST['filter_gender']) && $_POST['filter_gender'] == 'Female') ? 'selected' : ''; ?>>Female</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_race" class="form-label">Race</label>
                                                <select class="form-select" id="filter_race" name="filter_race">
                                                    <option value="all" <?php echo (isset($_POST['filter_race']) && $_POST['filter_race'] == 'all') ? 'selected' : ''; ?>>All Races</option>
                                                    <option value="African" <?php echo (isset($_POST['filter_race']) && $_POST['filter_race'] == 'African') ? 'selected' : ''; ?>>African</option>
                                                    <option value="Coloured" <?php echo (isset($_POST['filter_race']) && $_POST['filter_race'] == 'Coloured') ? 'selected' : ''; ?>>Coloured</option>
                                                    <option value="Indian" <?php echo (isset($_POST['filter_race']) && $_POST['filter_race'] == 'Indian') ? 'selected' : ''; ?>>Indian</option>
                                                    <option value="White" <?php echo (isset($_POST['filter_race']) && $_POST['filter_race'] == 'White') ? 'selected' : ''; ?>>White</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label for="filter_province" class="form-label">Province</label>
                                                <select class="form-select" id="filter_province" name="filter_province">
                                                    <option value="all" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'all') ? 'selected' : ''; ?>>All Provinces</option>
                                                    <option value="Eastern Cape" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Eastern Cape') ? 'selected' : ''; ?>>Eastern Cape</option>
                                                    <option value="Free State" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Free State') ? 'selected' : ''; ?>>Free State</option>
                                                    <option value="Gauteng" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Gauteng') ? 'selected' : ''; ?>>Gauteng</option>
                                                    <option value="KwaZulu-Natal" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'KwaZulu-Natal') ? 'selected' : ''; ?>>KwaZulu-Natal</option>
                                                    <option value="Limpopo" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Limpopo') ? 'selected' : ''; ?>>Limpopo</option>
                                                    <option value="Mpumalanga" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Mpumalanga') ? 'selected' : ''; ?>>Mpumalanga</option>
                                                    <option value="Northern Cape" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Northern Cape') ? 'selected' : ''; ?>>Northern Cape</option>
                                                    <option value="North West" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'North West') ? 'selected' : ''; ?>>North West</option>
                                                    <option value="Western Cape" <?php echo (isset($_POST['filter_province']) && $_POST['filter_province'] == 'Western Cape') ? 'selected' : ''; ?>>Western Cape</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3 d-flex align-items-end">
                                                <button type="submit" name="filter_beneficiaries" class="btn btn-outline-primary w-100">Apply Filters</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Search and Filter Section -->

            <!-- Beneficiaries Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Beneficiaries - <?php echo $db_company_name ?></h5>
                            <span class="badge bg-label-primary"><?php echo count($search_results) ?> Students</span>
                        </div>
                        <div class="card-body">
                            <?php if(count($search_results) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover" id="beneficiariesTable">
                                    <thead>
                                        <tr>
                                            <th>Full Names</th>
                                            <th>Date Of Birth</th>
                                            <th>Email</th>
                                            <th>Whatsapp</th>
                                            <th>Race</th>
                                            <th>Gender</th>
                                            <th>Institution</th>
                                            <th>Course</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php foreach($search_results as $row): 
                                            $url = toURL($row->email);
                                            $institution = '';
                                            $course = '';
                                            
                                            if(isset($beneficiary_academics[$row->email])) {
                                                $academic = $beneficiary_academics[$row->email];
                                                $institution = $academic->institution_name;
                                                $course = $academic->what_tostudy_one;
                                            }
                                        ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar avatar-sm me-3">
                                                            <?php 
                                                            $avatar = "assets/img/avatars/blackboy.png"; // default
                                                            if(isset($row->gender) && $row->gender == "Female") {
                                                                $avatar = "assets/img/avatars/blackgirl.jpeg";
                                                            }
                                                            ?>
                                                            <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                        </div>
                                                        <div>
                                                            <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                            <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo $row->date_of_birth ?></td>
                                                <td><?php echo $row->email ?></td>
                                                <td><?php echo $row->whatsapp ?></td>
                                                <td><?php echo $row->race ?></td>
                                                <td>
                                                    <span class="badge <?php echo $row->gender == 'Male' ? 'bg-label-primary' : 'bg-label-success'; ?>">
                                                        <?php echo $row->gender ?>
                                                    </span>
                                                </td>
                                                <td><?php echo $institution ?></td>
                                                <td><?php echo $course ?></td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                            <i class="bx bx-dots-vertical-rounded"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="view_bursary_user_details.php?id=<?php echo $url ?>">
                                                                <i class="bx bx-show me-1"></i> View Details
                                                            </a>
                                                            <a class="dropdown-item" href="corporate_process_payment.php?id=<?php echo $encrypted_id ?>&beneficiary=<?php echo toURL($row->email) ?>">
                                                                <i class="bx bx-credit-card me-1"></i> Process Payment
                                                            </a>
                                                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#messageModal" data-email="<?php echo $row->email ?>">
                                                                <i class="bx bx-envelope me-1"></i> Send Message
                                                            </a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-warning" href="#" data-bs-toggle="modal" data-bs-target="#removeBeneficiaryModal" data-email="<?php echo $row->email ?>" data-name="<?php echo $row->firstname.' '.$row->surname ?>">
                                                                <i class="bx bx-user-x me-1"></i> Remove Beneficiary
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bx bx-user-check bx-lg text-muted mb-3"></i>
                                    <p class="text-muted mb-2">No beneficiaries found</p>
                                    <small class="text-muted">Try adjusting your search or filter criteria</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Beneficiaries Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Message Modal -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Message to Beneficiary</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="messageForm">
                    <div class="mb-3">
                        <label for="recipientEmail" class="form-label">Recipient Email</label>
                        <input type="email" class="form-control" id="recipientEmail" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="messageSubject" class="form-label">Subject</label>
                        <input type="text" class="form-control" id="messageSubject" required>
                    </div>
                    <div class="mb-3">
                        <label for="messageContent" class="form-label">Message</label>
                        <textarea class="form-control" id="messageContent" rows="5" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="sendMessageBtn">Send Message</button>
            </div>
        </div>
    </div>
</div>

<!-- Remove Beneficiary Modal -->
<div class="modal fade" id="removeBeneficiaryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Remove Beneficiary</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to remove <span id="beneficiaryName" class="fw-semibold"></span> from your beneficiaries list?</p>
                <p class="text-muted">This action will not delete the user's account but will remove them from your bursary program.</p>
                <div class="mb-3">
                    <label for="removeReason" class="form-label">Reason for removal</label>
                    <textarea class="form-control" id="removeReason" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmRemoveBtn">Remove Beneficiary</button>
            </div>
        </div>
    </div>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Export Beneficiaries Data</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Export Format</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="exportFormat" id="formatCSV" value="csv" checked>
                        <label class="form-check-label" for="formatCSV">CSV (Excel)</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="exportFormat" id="formatPDF" value="pdf">
                        <label class="form-check-label" for="formatPDF">PDF Document</label>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Data to Include</label>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="includePersonal" checked>
                        <label class="form-check-label" for="includePersonal">Personal Information</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="includeAcademic" checked>
                        <label class="form-check-label" for="includeAcademic">Academic Information</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="includeContact">
                        <label class="form-check-label" for="includeContact">Contact Details</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="exportDataBtn">Export Data</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Message modal handler
    var messageModal = document.getElementById('messageModal');
    messageModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var recipientEmail = button.getAttribute('data-email');
        var modal = this;
        modal.querySelector('#recipientEmail').value = recipientEmail;
    });

    // Remove beneficiary modal handler
    var removeModal = document.getElementById('removeBeneficiaryModal');
    removeModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var email = button.getAttribute('data-email');
        var name = button.getAttribute('data-name');
        var modal = this;
        modal.querySelector('#beneficiaryName').textContent = name;
        
        // Set up confirm button
        modal.querySelector('#confirmRemoveBtn').onclick = function() {
            // AJAX call to remove beneficiary
            alert('Removing beneficiary: ' + name);
            // In a real implementation, you would make an AJAX call here
            var bsModal = bootstrap.Modal.getInstance(modal);
            bsModal.hide();
        };
    });

    // Send message button handler
    document.getElementById('sendMessageBtn').addEventListener('click', function() {
        var subject = document.getElementById('messageSubject').value;
        var content = document.getElementById('messageContent').value;
        
        if(subject && content) {
            // AJAX call to send message
            alert('Message would be sent with subject: ' + subject);
            // In a real implementation, you would make an AJAX call here
            var modal = bootstrap.Modal.getInstance(messageModal);
            modal.hide();
        } else {
            alert('Please fill in all fields');
        }
    });

    // Export data button handler
    document.getElementById('exportDataBtn').addEventListener('click', function() {
        var format = document.querySelector('input[name="exportFormat"]:checked').value;
        alert('Exporting data in ' + format + ' format');
        // In a real implementation, you would make an AJAX call here
        var modal = bootstrap.Modal.getInstance(document.getElementById('exportModal'));
        modal.hide();
    });

    // Search functionality
    document.getElementById('searchInput').addEventListener('keyup', function() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("beneficiariesTable");
        tr = table.getElementsByTagName("tr");

        for (i = 0; i < tr.length; i++) {
            td = tr[i].getElementsByTagName("td")[0]; // Search in the first column (Name)
            if (td) {
                txtValue = td.textContent || td.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    tr[i].style.display = "";
                } else {
                    tr[i].style.display = "none";
                }
            }       
        }
    });
});
</script>
</body>
</html>