<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
    }
}

$company_name = str_replace(' ', '+', trim($db_company_name));

// Fetch administrators
$api_url = $APIBASE."users/users_exec.php?action=list_corporates_users&corporate=".$company_name."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$administrators = json_decode($response);

// Handle search functionality
$search_results = [];
if(isset($_POST['search_administrators'])) {
    $search_term = $_POST['search_term'];
    $search_field = $_POST['search_field'];
    
    if(!empty($search_term)) {
        foreach($administrators as $admin) {
            $field_value = '';
            switch($search_field) {
                case 'name':
                    $field_value = $admin->firstname . ' ' . $admin->surname;
                    break;
                case 'email':
                    $field_value = $admin->email;
                    break;
                default:
                    $field_value = $admin->firstname . ' ' . $admin->surname;
            }
            
            if(stripos($field_value, $search_term) !== false) {
                $search_results[] = $admin;
            }
        }
    } else {
        $search_results = $administrators;
    }
} else {
    $search_results = $administrators;
}

// Handle add administrator form submission
if(isset($_POST['add_administrator'])) {
    $firstname = $_POST['firstname'];
    $surname = $_POST['surname'];
    $email = $_POST['email'];
    $user_type = 'corporate';
    $action = $db_company_name;
    $profile_ptc = 5; // Initial profile completion percentage
    
    // Check if email already exists
    $api_url = $APIBASE."users/users_exec.php?action=check_email_exists_on_registration&email=".$email."";
    $client = curl_init($api_url);
    curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($client);
    $email_exists = json_decode($response);
    
    if($email_exists == "exists") {
        $add_error = "Email address already exists in the system.";
    } else {
        // Add new administrator
        $api_url = $APIBASE."users/users_exec.php?action=initial_user_registration";
        $client = curl_init($api_url);
        $form_data = array(
            'firstname' => $firstname,
            'surname' => $surname,
            'email' => $email,
            'profile_ptc' => $profile_ptc,
            'user_type' => $user_type,
            'action' => $action
        );
        
        curl_setopt($client, CURLOPT_POST, true);
        curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        $result = json_decode($response);
        
        if($result && count($result) > 0 && $result[0]->success == '1') {
            $add_success = "Administrator added successfully. They will receive an email with instructions to complete their profile.";
            // Refresh the administrators list
            $api_url = $APIBASE."users/users_exec.php?action=list_corporates_users&corporate=".$company_name."";
            $client = curl_init($api_url);
            curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($client);
            $administrators = json_decode($response);
            $search_results = $administrators;
        } else {
            $add_error = "Failed to add administrator. Please try again.";
        }
    }
}

// Handle remove administrator
if(isset($_POST['remove_administrator'])) {
    $email = $_POST['email'];
    
    // Update user type to remove corporate association
    $api_url = $APIBASE."users/users_exec.php?action=update_user_role";
    $client = curl_init($api_url);
    $form_data = array(
        'email' => $email,
        'user_type' => 'user', // Change back to regular user
        'action' => 'none'
    );
    
    curl_setopt($client, CURLOPT_POST, true);
    curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
    curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($client);
    $result = json_decode($response);
    
    if($result && count($result) > 0 && $result[0]->success == '1') {
        $remove_success = "Administrator removed successfully.";
        // Refresh the administrators list
        $api_url = $APIBASE."users/users_exec.php?action=list_corporates_users&corporate=".$company_name."";
        $client = curl_init($api_url);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        $administrators = json_decode($response);
        $search_results = $administrators;
    } else {
        $remove_error = "Failed to remove administrator. Please try again.";
    }
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search administrators..."
                        aria-label="Search..."
                        id="searchInput"
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Administrators Management</h3>
                                    <p class="mb-0">Manage administrators for <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_dashboard.php?id=<?php echo $encrypted_id ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAdminModal">
                                        <i class="bx bx-user-plus me-1"></i> Add Administrator
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Alert Messages -->
            <?php if(isset($add_success)): ?>
            <div class="alert alert-success alert-dismissible mb-4" role="alert">
                <i class="bx bx-check-circle me-2"></i> <?php echo $add_success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <?php if(isset($add_error)): ?>
            <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                <i class="bx bx-error-circle me-2"></i> <?php echo $add_error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <?php if(isset($remove_success)): ?>
            <div class="alert alert-success alert-dismissible mb-4" role="alert">
                <i class="bx bx-check-circle me-2"></i> <?php echo $remove_success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <?php if(isset($remove_error)): ?>
            <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                <i class="bx bx-error-circle me-2"></i> <?php echo $remove_error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <!-- /Alert Messages -->

            <!-- Search Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-8 mb-3">
                                        <label for="search_term" class="form-label">Search Administrators</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="search_term" name="search_term" placeholder="Search administrators..." value="<?php echo isset($_POST['search_term']) ? $_POST['search_term'] : ''; ?>">
                                            <select class="form-select" name="search_field" style="max-width: 130px;">
                                                <option value="name" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'name') ? 'selected' : ''; ?>>Name</option>
                                                <option value="email" <?php echo (isset($_POST['search_field']) && $_POST['search_field'] == 'email') ? 'selected' : ''; ?>>Email</option>
                                            </select>
                                            <button type="submit" name="search_administrators" class="btn btn-primary">Search</button>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3 d-flex align-items-end">
                                        <a href="corporate_administrators.php?id=<?php echo $encrypted_id; ?>" class="btn btn-outline-secondary w-100">Clear Filters</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Search Section -->

            <!-- Administrators Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Administrators - <?php echo $db_company_name ?></h5>
                            <span class="badge bg-label-primary"><?php echo count($search_results) ?> Administrators</span>
                        </div>
                        <div class="card-body">
                            <?php if(count($search_results) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover" id="administratorsTable">
                                    <thead>
                                        <tr>
                                            <th>Full Names</th>
                                            <th>Email</th>
                                            <th>Profile Status</th>
                                            <th>Registration Date</th>
                                            <th>Last Login</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php foreach($search_results as $row): 
                                            $url = toURL($row->email);
                                            $profile_status = 'Incomplete';
                                            $status_class = 'warning';
                                            
                                            if($row->profile_ptc == 100) {
                                                $profile_status = 'Complete';
                                                $status_class = 'success';
                                            } elseif($row->profile_ptc > 50) {
                                                $profile_status = 'In Progress';
                                                $status_class = 'info';
                                            }
                                        ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar avatar-sm me-3">
                                                            <?php 
                                                            $avatar = "assets/img/avatars/blackboy.png"; // default
                                                            ?>
                                                            <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                        </div>
                                                        <div>
                                                            <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                            <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo $row->email ?></td>
                                                <td>
                                                    <span class="badge bg-label-<?php echo $status_class; ?>">
                                                        <?php echo $profile_status ?> (<?php echo $row->profile_ptc ?>%)
                                                    </span>
                                                </td>
                                                <td><?php echo date('M j, Y', strtotime($row->create_date)) ?></td>
                                                <td><?php echo $row->last_login ? date('M j, Y', strtotime($row->last_login)) : 'Never' ?></td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                            <i class="bx bx-dots-vertical-rounded"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="view_corporate_admin.php?id=<?php echo $url ?>">
                                                                <i class="bx bx-show me-1"></i> View Details
                                                            </a>
                                                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#messageModal" data-email="<?php echo $row->email ?>">
                                                                <i class="bx bx-envelope me-1"></i> Send Message
                                                            </a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-warning" href="#" data-bs-toggle="modal" data-bs-target="#resetPasswordModal" data-email="<?php echo $row->email ?>" data-name="<?php echo $row->firstname.' '.$row->surname ?>">
                                                                <i class="bx bx-refresh me-1"></i> Reset Password
                                                            </a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-danger" href="#" data-bs-toggle="modal" data-bs-target="#removeAdminModal" data-email="<?php echo $row->email ?>" data-name="<?php echo $row->firstname.' '.$row->surname ?>">
                                                                <i class="bx bx-user-x me-1"></i> Remove Admin
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bx bx-user-x bx-lg text-muted mb-3"></i>
                                    <p class="text-muted mb-2">No administrators found</p>
                                    <small class="text-muted">Try adding administrators using the button above</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Administrators Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Add Administrator Modal -->
<div class="modal fade" id="addAdminModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Administrator</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="firstname" class="form-label">First Name</label>
                        <input type="text" class="form-control" id="firstname" name="firstname" required>
                    </div>
                    <div class="mb-3">
                        <label for="surname" class="form-label">Surname</label>
                        <input type="text" class="form-control" id="surname" name="surname" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                        <div class="form-text">The administrator will receive an email with instructions to complete their profile.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_administrator" class="btn btn-primary">Add Administrator</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Message Modal -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Message to Administrator</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="messageForm">
                    <div class="mb-3">
                        <label for="recipientEmail" class="form-label">Recipient Email</label>
                        <input type="email" class="form-control" id="recipientEmail" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="messageSubject" class="form-label">Subject</label>
                        <input type="text" class="form-control" id="messageSubject" required>
                    </div>
                    <div class="mb-3">
                        <label for="messageContent" class="form-label">Message</label>
                        <textarea class="form-control" id="messageContent" rows="5" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="sendMessageBtn">Send Message</button>
            </div>
        </div>
    </div>
</div>

<!-- Reset Password Modal -->
<div class="modal fade" id="resetPasswordModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reset Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to reset the password for <span id="adminName" class="fw-semibold"></span>?</p>
                <p class="text-muted">The administrator will receive an email with instructions to set a new password.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning" id="confirmResetBtn">Reset Password</button>
            </div>
        </div>
    </div>
</div>

<!-- Remove Administrator Modal -->
<div class="modal fade" id="removeAdminModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Remove Administrator</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="">
                <div class="modal-body">
                    <p>Are you sure you want to remove <span id="removeAdminName" class="fw-semibold"></span> from your administrators list?</p>
                    <p class="text-muted">This action will not delete the user's account but will remove their administrator privileges for your organization.</p>
                    <div class="mb-3">
                        <label for="removeReason" class="form-label">Reason for removal</label>
                        <textarea class="form-control" id="removeReason" name="removeReason" rows="3"></textarea>
                    </div>
                    <input type="hidden" id="removeEmail" name="email">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="remove_administrator" class="btn btn-danger">Remove Administrator</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Message modal handler
    var messageModal = document.getElementById('messageModal');
    messageModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var recipientEmail = button.getAttribute('data-email');
        var modal = this;
        modal.querySelector('#recipientEmail').value = recipientEmail;
    });

    // Reset password modal handler
    var resetModal = document.getElementById('resetPasswordModal');
    resetModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var email = button.getAttribute('data-email');
        var name = button.getAttribute('data-name');
        var modal = this;
        modal.querySelector('#adminName').textContent = name;
        
        // Set up confirm button
        modal.querySelector('#confirmResetBtn').onclick = function() {
            // AJAX call to reset password
            alert('Password reset for: ' + name);
            // In a real implementation, you would make an AJAX call here
            var bsModal = bootstrap.Modal.getInstance(modal);
            bsModal.hide();
        };
    });

    // Remove admin modal handler
    var removeModal = document.getElementById('removeAdminModal');
    removeModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var email = button.getAttribute('data-email');
        var name = button.getAttribute('data-name');
        var modal = this;
        modal.querySelector('#removeAdminName').textContent = name;
        modal.querySelector('#removeEmail').value = email;
    });

    // Send message button handler
    document.getElementById('sendMessageBtn').addEventListener('click', function() {
        var subject = document.getElementById('messageSubject').value;
        var content = document.getElementById('messageContent').value;
        
        if(subject && content) {
            // AJAX call to send message
            alert('Message would be sent with subject: ' + subject);
            // In a real implementation, you would make an AJAX call here
            var modal = bootstrap.Modal.getInstance(messageModal);
            modal.hide();
        } else {
            alert('Please fill in all fields');
        }
    });

    // Search functionality
    document.getElementById('searchInput').addEventListener('keyup', function() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("administratorsTable");
        tr = table.getElementsByTagName("tr");

        for (i = 0; i < tr.length; i++) {
            td = tr[i].getElementsByTagName("td")[0]; // Search in the first column (Name)
            if (td) {
                txtValue = td.textContent || td.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    tr[i].style.display = "";
                } else {
                    tr[i].style.display = "none";
                }
            }       
        }
    });
});
</script>
</body>
</html>