<?php


class Users
{
   private $connect = '';

   function __construct()
   {
      $this->database_connection();
   }


   function database_connection()
   {
      $this->connect = new PDO("mysql:host=127.0.0.1;dbname=levelsupcareers", "levelsupcareers", "levelsupcareers");
   }

   function testConnection()
   {

    $query = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'levelsupcareers'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $data['connect'] = true;
       }

       return $data;
       
    }

   }


   function checkEmailExists($email)
   {

    $query = "SELECT * FROM users_logging_tbl WHERE email='".$email."'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $db_email = $row['email'];
          return "exists";
       }
       return "false";
      }
   }


   function checkCorporateExists($registration)
   {

    $query = "SELECT * FROM bursary_provider_tbl WHERE company_registration='".$registration."'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $db_email = $row['company_registration'];
          return "exists";
       }
       return "false";
      }
   }

   function initialUserRegistration()
   {
    
    if(isset($_POST["email"]))
    {     

       
       $form_data = array(
          ':firstname'  => $_POST["firstname"],
          ':surname'  => $_POST["surname"],
          ':email'  => $_POST["email"],
          ':profile_ptc'  => $_POST["profile_ptc"],
          ':user_type'  => $_POST["user_type"],
          ':action'  => $_POST["action"]
       );
       
       $query = "
       INSERT INTO users_logging_tbl 
       (firstname, surname, email, profile_ptc, user_type, action) 
       VALUES 
       (:firstname, :surname, :email, :profile_ptc, :user_type, :action)
       ";

       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
       }
    }
    else
    {
        $data[] = array(
           'success' => '0'
        );
     }
     return $data;
   }


   function listUserLoggingDetailsByEmail($email)
   {
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }


   function listCorporates()
   {
      $data = array();

      $query = "SELECT * FROM bursary_provider_tbl ORDER BY bur_prv_id DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function viewCorporateDetails($id)
   {
      $data = array();

      $query = "SELECT * FROM bursary_provider_tbl WHERE bur_prv_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function listCorporateUsersByName($corporate)
   {
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE action='".$corporate."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function listCorporatePayments($corporate)
   {
      $data = array();

      $query = "SELECT * FROM corporate_finance_tbl WHERE corporate='".$corporate."' ORDER BY year, trunche DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }      



   function listUserLoggingDetailsByRow($id)
   {
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE usr_log_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function updateUserLoggingProgress()
   {
    if(isset($_POST["profile_ptc"]))
    {
       $form_data = array(
             ':user_type'  => $_POST["user_type"],
             ':profile_ptc'  => $_POST["profile_ptc"],
             ':action'  => $_POST["action"],             
             ':email'  => $_POST["email"]
       );

       $query = "
       UPDATE users_logging_tbl 
       SET user_type = :user_type, profile_ptc = :profile_ptc, action = :action
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function assignUserBursary()
   {
    if(isset($_POST["bursary_from"]))
    {
       $form_data = array(
             ':bursary_from'  => $_POST["bursary_from"],
             ':action'  => $_POST["action"],
             ':email'  => $_POST["email"]
       );

       $query = "
       UPDATE users_logging_tbl 
       SET bursary_from = :bursary_from, action = :action
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function authenticateUser($username)
   {

    $data = array();

    $query = "SELECT * FROM users_logging_tbl WHERE email='".$username."'";

    $statement = $this->connect->prepare($query);


      if($statement->execute()){
         while($row = $statement->fetch(PDO::FETCH_ASSOC)){
              $data[] = $row;
         }
           
         return $data;
      } 
       
   }


   function generateTempOTP()
   {
    
    if(isset($_POST["username"]))
    {


      $obj = new Users();
      $obj->deleteOldOTP();
      $obj->deleteUserOTP($_POST["username"]);


       $form_data = array(
          ':username'  => $_POST["username"],
          ':firstname'  => $_POST["firstname"],
          ':surname'  => $_POST["surname"],
          ':otp'  => $_POST["otp"],
          ':user_type'  => $_POST["user_type"],
          ':lifespan'  => $_POST["lifespan"]
       );
       
       $query = "
       INSERT INTO temp_auth_tbl 
       (username, firstname, surname, otp, user_type, lifespan) 
       VALUES 
       (:username, :firstname, :surname, :otp, :user_type, :lifespan)
       ";

       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
       }
    }
    else
    {
        $data[] = array(
           'success' => '0'
        );
     }
     return $data;
   }


   function deleteOldOTP()
   {
      
     $query = "DELETE FROM temp_auth_tbl WHERE created_time < (NOW() - INTERVAL 30 MINUTE)";
     $statement = $this->connect->prepare($query);
     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }

      return $data;
   }

   function deleteUserOTP($username)
   {
      
     $query = "DELETE FROM temp_auth_tbl WHERE username='".$username."'";
     $statement = $this->connect->prepare($query);
     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }

      return $data;
   }   


   function userLogin($username, $otp)
   {

   $obj = new Users();
   $data = array();

    $query = "SELECT * FROM temp_auth_tbl WHERE username='".$username."' AND otp='".$otp."'";

    $statement = $this->connect->prepare($query);


      if($statement->execute()){
         while($row = $statement->fetch(PDO::FETCH_ASSOC)){
            $data[] = $row;

            $obj->deleteOldOTP();
            $obj->deleteUserOTP($username);

         }
           
         return $data;
      } 
       
   }

   function checkUserProfileTypeExists($email)
   {

    $query = "SELECT * FROM usr_profile_type_tbl WHERE email='".$email."'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $db_email = $row['email'];
          return "exists";
       }
       return "false";
      }
   }


   function addUserProfileInfo()
   {
    if(isset($_POST["user_type"]))
    {
       $form_data = array(
             ':user_type'  => $_POST["user_type"],
             ':study_university'  => $_POST["study_university"],
             ':study_tvet'  => $_POST["study_tvet"],
             ':require_bursary'  => $_POST["require_bursary"],
             ':graduate_programme'  => $_POST["graduate_programme"],
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],             
             ':email'  => $_POST["email"]
       );

       $query = "
       INSERT INTO usr_profile_type_tbl 
       (user_type, study_university, study_tvet, require_bursary, graduate_programme, firstname, surname,email) 
       VALUES 
       (:user_type, :study_university, :study_tvet, :require_bursary, :graduate_programme, :firstname, :surname, :email)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  

   function updateUserProfileInfo()
   {
    if(isset($_POST["study_university"]))
    {
       $form_data = array(
             ':study_university'  => $_POST["study_university"],
             ':study_tvet'  => $_POST["study_tvet"],
             ':require_bursary'  => $_POST["require_bursary"],
             ':graduate_programme'  => $_POST["graduate_programme"],
             ':email'  => $_POST["email"]
       );

       $query = "
       UPDATE usr_profile_type_tbl 
       SET study_university = :study_university, study_tvet = :study_tvet, require_bursary = :require_bursary, graduate_programme = :graduate_programme
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function addUserPersonalInfo()
   {
    if(isset($_POST["date_of_birth"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"],
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':role'  => $_POST["role"],
             ':promo_code'  => $_POST["promo_code"],
             ':id_number'  => $_POST["id_number"],
             ':date_of_birth'  => $_POST["date_of_birth"],
             ':whatsapp'  => $_POST["whatsapp"],
             ':alt_number'  => $_POST["alt_number"],
             ':race'  => $_POST["race"],
             ':gender'  => $_POST["gender"],  
             ':nationality'  => $_POST["nationality"],
             ':other_nationality'  => $_POST["other_nationality"],
             ':residential_address'  => $_POST["residential_address"],
             ':province'  => $_POST["province"],
             ':district'  => $_POST["district"],
             ':municipality'  => $_POST["municipality"],
             ':disability'  => $_POST["disability"],
             ':communication'  => $_POST["communication"],
             ':guardian_name'  => $_POST["guardian_name"],                          
             ':guardian_number'  => $_POST["guardian_number"]
       );

       $query = "
       INSERT INTO user_personal_info_tbl 
       (email, firstname, surname, role, promo_code, id_number, date_of_birth, whatsapp, alt_number, race, gender, nationality, other_nationality, residential_address, province, district, municipality, disability, communication, guardian_name, guardian_number) 
       VALUES 
       (:email, :firstname, :surname, :role, :promo_code, :id_number, :date_of_birth, :whatsapp, :alt_number, :race, :gender, :nationality, :other_nationality, :residential_address, :province, :district, :municipality, :disability, :communication, :guardian_name, :guardian_number)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  


   function updateUserPersonalDetails()
   {
    if(isset($_POST["date_of_birth"]))
    {

       $form_data = array(
             ':email'  => $_POST["email"],
             ':role'  => $_POST["role"],
             ':promo_code'  => $_POST["promo_code"],
             ':id_number'  => $_POST["id_number"],
             ':date_of_birth'  => $_POST["date_of_birth"],
             ':whatsapp'  => $_POST["whatsapp"],
             ':alt_number'  => $_POST["alt_number"],
             ':race'  => $_POST["race"],
             ':gender'  => $_POST["gender"],  
             ':nationality'  => $_POST["nationality"],
             ':other_nationality'  => $_POST["other_nationality"],
             ':residential_address'  => $_POST["residential_address"],
             ':province'  => $_POST["province"],
             ':district'  => $_POST["district"],
             ':municipality'  => $_POST["municipality"],
             ':disability'  => $_POST["disability"],
             ':communication'  => $_POST["communication"],
             ':guardian_name'  => $_POST["guardian_name"],                          
             ':guardian_number'  => $_POST["guardian_number"]
       );       

       $query = "
       UPDATE user_personal_info_tbl 
       SET role = :role, promo_code = :promo_code, id_number = :id_number, date_of_birth = :date_of_birth, whatsapp = :whatsapp, alt_number = :alt_number, race = :race, gender = :gender, nationality = :nationality, other_nationality = :other_nationality, residential_address = :residential_address, province = :province, district = :district, municipality = :municipality, disability = :disability, communication = :communication, guardian_name = :guardian_name, guardian_number = :guardian_number
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }

   function checkUserPersonalInfoExists($email)
   {

    $query = "SELECT * FROM user_personal_info_tbl WHERE email='".$email."'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $db_email = $row['email'];
          return "exists";
       }
       return "false";
      }
   }

   function addUserAcademicInfo()
   {
    if(isset($_POST["highest_qualification"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"],
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':highest_qualification'  => $_POST["highest_qualification"],
             ':current_study'  => $_POST["current_study"],
             ':institution_name'  => $_POST["institution_name"],
             ':academic_report'  => $_POST["academic_report"],                          
             ':number_of_subjects'  => $_POST["number_of_subjects"],
             ':what_tostudy_one'  => $_POST["what_tostudy_one"],
             ':what_tostudy_two'  => $_POST["what_tostudy_two"],
             ':what_tostudy_three'  => $_POST["what_tostudy_three"],
             ':where_tostudy_one'  => $_POST["where_tostudy_one"],
             ':where_tostudy_two'  => $_POST["where_tostudy_two"],
             ':where_tostudy_three'  => $_POST["where_tostudy_three"]
       );

       $query = "
       INSERT INTO user_academics_info_tbl 
       (email, firstname, surname, highest_qualification, current_study, institution_name, academic_report, number_of_subjects, what_tostudy_one, what_tostudy_two, what_tostudy_three, where_tostudy_one, where_tostudy_two, where_tostudy_three) 
       VALUES 
       (:email, :firstname, :surname, :highest_qualification, :current_study, :institution_name, :academic_report, :number_of_subjects, :what_tostudy_one, :what_tostudy_two, :what_tostudy_three, :where_tostudy_one, :where_tostudy_two, :where_tostudy_three)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  



   function updateUserAcademicPage()
   {
    if(isset($_POST["highest_qualification"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"],
             ':highest_qualification'  => $_POST["highest_qualification"],
             ':current_study'  => $_POST["current_study"],
             ':institution_name'  => $_POST["institution_name"],
             ':academic_report'  => $_POST["academic_report"],                          
             ':number_of_subjects'  => $_POST["number_of_subjects"],
             ':what_tostudy_one'  => $_POST["what_tostudy_one"],
             ':what_tostudy_two'  => $_POST["what_tostudy_two"],
             ':what_tostudy_three'  => $_POST["what_tostudy_three"],
             ':where_tostudy_one'  => $_POST["where_tostudy_one"],
             ':where_tostudy_two'  => $_POST["where_tostudy_two"],
             ':where_tostudy_three'  => $_POST["where_tostudy_three"]
       );      

       $query = "
       UPDATE user_academics_info_tbl 
       SET highest_qualification = :highest_qualification, current_study = :current_study, institution_name = :institution_name, academic_report = :academic_report, number_of_subjects = :number_of_subjects, what_tostudy_one = :what_tostudy_one, what_tostudy_two = :what_tostudy_two, what_tostudy_three = :what_tostudy_three, where_tostudy_one = :where_tostudy_one, where_tostudy_two = :where_tostudy_two, where_tostudy_three = :where_tostudy_three
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function checkUserAcademicExists($email)
   {

    $query = "SELECT * FROM user_academics_info_tbl WHERE email='".$email."'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $db_email = $row['email'];
          return "exists";
       }
       return "false";
      }
   }


   function addUserUploadData()
   {
    if(isset($_POST["filename"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"],
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':filename'  => $_POST["filename"],
             ':directory'  => $_POST["directory"],
             ':upload_type'  => $_POST["upload_type"]
       );

       $query = "
       INSERT INTO upload_activity_tbl 
       (email, firstname, surname, filename, directory, upload_type) 
       VALUES 
       (:email, :firstname, :surname, :filename, :directory, :upload_type)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function updateUserUploadStatus()
   {
    if(isset($_POST["upload_id"]))
    {
       $form_data = array(
             ':status'  => $_POST["status"],
             ':upload_id'  => $_POST["upload_id"]
       );

       $query = "
       UPDATE upload_activity_tbl 
       SET status = :status
       WHERE upload_id = :upload_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function updateUserRoleStatus()
   {
    if(isset($_POST["email"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"],
             ':action'  => $_POST["action"],
             ':user_type'  => $_POST["user_type"]
       );

       $query = "
       UPDATE users_logging_tbl 
       SET user_type = :user_type, action = :action
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }

   function listUserUploadedDocument($email, $document)
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE email='".$email."' AND upload_type='".$document."' ORDER BY upload_id DESC LIMIT 1";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  

   function listUserUploads($email)
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  

   function listUserUploadsByID($id)
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE upload_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }     

   function listAllUserUploads()
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE status='New' ORDER BY upload_id";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }         


   function listApprovedUserUploads()
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE status='Approved' ORDER BY upload_id";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  


   function listRejectedUserUploads()
   {
      $data = array();

      $query = "SELECT * FROM upload_activity_tbl WHERE status='Rejected' ORDER BY upload_id";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }            


   function addInstitution()
   {
    if(isset($_POST["institution_name"]))
    {
       $form_data = array(
             ':institution_name'  => $_POST["institution_name"],
             ':tags'  => $_POST["tags"],
             ':latitude'  => $_POST["latitude"],
             ':longitude'  => $_POST["longitude"],
             ':institution_address'  => $_POST["institution_address"],
             ':province'  => $_POST["province"]
       );

       $query = "
       INSERT INTO institution_tbl 
       (institution_name, tags, latitude, longitude, institution_address, province) 
       VALUES 
       (:institution_name, :tags, :latitude, :longitude, :institution_address, :province)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function addQualification()
   {
    if(isset($_POST["qualification_name"]))
    {
       $form_data = array(
             ':nqf_details'  => $_POST["nqf_details"],
             ':nqf_level'  => $_POST["nqf_level"],
             ':nqf_name'  => $_POST["nqf_name"],
             ':institution'  => $_POST["institution"],
             ':qualification_name'  => $_POST["qualification_name"],
             ':faculty'  => $_POST["faculty"],
             ':specialization'  => $_POST["specialization"],
             ':abbreviation'  => $_POST["abbreviation"],
             ':duration_years'  => $_POST["duration_years"],
             ':annual_average_fees'  => $_POST["annual_average_fees"],
             ':duration_months'  => $_POST["duration_months"],
             ':amount'  => $_POST["amount"],
             ':nbt'  => $_POST["nbt"],
             ':matric_exemption'  => $_POST["matric_exemption"],
             ':aps'  => $_POST["aps"],
             ':additional_comments'  => $_POST["additional_comments"],
             ':application_open_date'  => $_POST["application_open_date"],
             ':application_close_date'  => $_POST["application_close_date"],
             ':application_form'  => $_POST["application_form"],             
             ':source'  => $_POST["source"]
       );

       $query = "
       INSERT INTO qualification_tbl 
       (nqf_details, nqf_level, nqf_name, institution, qualification_name, faculty, specialization, abbreviation, duration_years, annual_average_fees, duration_months, amount, nbt, matric_exemption, aps, additional_comments, application_open_date, application_close_date, application_form, source) 
       VALUES 
       (:nqf_details, :nqf_level, :nqf_name, :institution, :qualification_name, :faculty, :specialization, :abbreviation, :duration_years, :annual_average_fees, :duration_months, :amount, :nbt, :matric_exemption, :aps, :additional_comments, :application_open_date, :application_close_date, :application_form, :source)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }

   function updateQualification()
   {
    if(isset($_POST["qualification_name"]))
    {
       $form_data = array(
             ':qualification_id'  => $_POST["qualification_id"],
             ':tags'  => $_POST["tags"],
             ':nqf_details'  => $_POST["nqf_details"],
             ':nqf_level'  => $_POST["nqf_level"],
             ':nqf_name'  => $_POST["nqf_name"],
             ':institution'  => $_POST["institution"],
             ':qualification_name'  => $_POST["qualification_name"],
             ':faculty'  => $_POST["faculty"],
             ':specialization'  => $_POST["specialization"],
             ':abbreviation'  => $_POST["abbreviation"],
             ':duration_years'  => $_POST["duration_years"],
             ':annual_average_fees'  => $_POST["annual_average_fees"],
             ':duration_months'  => $_POST["duration_months"],
             ':amount'  => $_POST["amount"],
             ':nbt'  => $_POST["nbt"],
             ':matric_exemption'  => $_POST["matric_exemption"],
             ':aps'  => $_POST["aps"],
             ':additional_comments'  => $_POST["additional_comments"],
             ':application_open_date'  => $_POST["application_open_date"],
             ':application_close_date'  => $_POST["application_close_date"],
             ':application_form'  => $_POST["application_form"],             
             ':source'  => $_POST["source"]
       );

       $query = "
       UPDATE qualification_tbl 
       SET nqf_details = :nqf_details, tags = :tags, nqf_level = :nqf_level, nqf_name = :nqf_name, institution = :institution, qualification_name = :qualification_name, faculty = :faculty, specialization = :specialization, abbreviation = :abbreviation, duration_years = :duration_years, annual_average_fees = :annual_average_fees, duration_months = :duration_months, amount = :amount, nbt = :nbt, matric_exemption = :matric_exemption, aps = :aps, additional_comments = :additional_comments, application_open_date = :application_open_date, application_close_date = :application_close_date, application_form = :application_form, source = :source
       WHERE qualification_id = :qualification_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function listInstitutionDetails($id)
   {
      $date = array();
      
      $query = "SELECT * FROM institution_tbl WHERE institution_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   



   function listUserWhereToStudy($keyword)
   {

      $search = '%'.$keyword.'%';
      $data = array();

      $query = "SELECT * FROM institution_tbl WHERE tags LIKE '".$search."' LIMIT 3";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }        


   function listUserWhatToStudy($keyword)
   {

      $search = '%'.$keyword.'%';
      $data = array();

      $query = "SELECT * FROM qualification_tbl WHERE tags LIKE '".$search."' LIMIT 5";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }        


   function viewUsersDashboard($email)
   {
      
      $data = array();

      $query = "
      SELECT 
      (SELECT COUNT(DISTINCT(upload_type)) FROM upload_activity_tbl WHERE email='".$email."') AS number_of_uploaded_documents, 
      (SELECT COUNT(DISTINCT(upload_type)) FROM upload_activity_tbl WHERE email='".$email."') AS total_administrators;       
      ";
        $statement = $this->connect->prepare($query);
        if($statement->execute())
        {
           while($row = $statement->fetch(PDO::FETCH_ASSOC))
           {
              $data[] = $row;
           }
           return $data;
        }
   } 

   function viewSystemDashboard()
   {
      
      $data = array();

      $query = "
      SELECT 
      (SELECT COUNT(*) FROM users_logging_tbl) AS total_number_of_users, 
      (SELECT COUNT(*) FROM institution_tbl) AS total_institutions, 
      (SELECT COUNT(*) FROM qualification_tbl) AS total_qualifications, 
      (SELECT COUNT(*) FROM faculty_tbl) AS total_faculties, 
      (SELECT COUNT(*) FROM specialization_tbl) AS total_specialization, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE profile_ptc = '5') AS total_new_registrations, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE user_type = 'corporate') AS total_corporate, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE user_type = 'super') AS total_super_user, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE profile_ptc = '100') AS total_full_registrations, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE profile_ptc > 5 AND profile_ptc < 100) AS total_inprogress_users, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE date(create_date)=CURDATE()) AS registrations_today;
      ";


        $statement = $this->connect->prepare($query);
        if($statement->execute())
        {
           while($row = $statement->fetch(PDO::FETCH_ASSOC))
           {
              $data[] = $row;
           }
           return $data;
        }
   } 

   function viewCorporateDashboard($corporate)
   {
      
      $data = array();

      $query = "
      SELECT 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE action='".$corporate."') AS total_administrators, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE bursary_from='".$corporate."') AS total_beneficiaries, 
      (SELECT COUNT(*) FROM corporate_finance_tbl WHERE corporate='".$corporate."') AS total_transactions, 
      (SELECT COUNT(*) FROM users_logging_tbl WHERE date(create_date)=CURDATE()) AS registrations_today;
      ";


        $statement = $this->connect->prepare($query);
        if($statement->execute())
        {
           while($row = $statement->fetch(PDO::FETCH_ASSOC))
           {
              $data[] = $row;
           }
           return $data;
        }
   }    

   function listUserLogging()
   {
      
      $data = array();

      $query = "SELECT * FROM users_logging_tbl ORDER BY usr_log_id DESC LIMIT 10";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }


   function updateUserPersonalInfo()
   {
    if(isset($_POST["date_of_birth"]))
    {
       $form_data = array(
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':promo_code'  => $_POST["promo_code"],
             ':id_number'  => $_POST["id_number"],
             ':date_of_birth'  => $_POST["date_of_birth"],
             ':whatsapp'  => $_POST["whatsapp"],
             ':alt_number'  => $_POST["alt_number"],
             ':race'  => $_POST["race"],
             ':gender'  => $_POST["gender"],  
             ':nationality'  => $_POST["nationality"],
             ':other_nationality'  => $_POST["other_nationality"],
             ':residential_address'  => $_POST["residential_address"],
             ':province'  => $_POST["province"],
             ':district'  => $_POST["district"],
             ':municipality'  => $_POST["municipality"],
             ':disability'  => $_POST["disability"],
             ':guardian_name'  => $_POST["guardian_name"],                          
             ':guardian_number'  => $_POST["guardian_number"],
             ':role'  => $_POST["role"],
             ':usr_id'  => $_POST["usr_id"]

       );

       $query = "
       UPDATE user_personal_info_tbl 
       SET firstname = :firstname, surname = :surname, promo_code = :promo_code, id_number = :id_number, date_of_birth = :date_of_birth, whatsapp = :whatsapp, alt_number = :alt_number, race = :race, gender = :gender, nationality = :nationality, other_nationality = :other_nationality, residential_address = :residential_address, province = :province, district = :district, municipality = :municipality, disability = :disability, guardian_name = :guardian_name, guardian_number = :guardian_number, role = :role
       WHERE usr_id = :usr_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  

   function updateUserAcademicInfo()
   {
    if(isset($_POST["highest_qualification"]))
    {
       $form_data = array(
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':highest_qualification'  => $_POST["highest_qualification"],
             ':current_study'  => $_POST["current_study"],
             ':institution_name'  => $_POST["institution_name"],
             ':academic_report'  => $_POST["academic_report"],                          
             ':number_of_subjects'  => $_POST["number_of_subjects"],
             ':what_tostudy_one'  => $_POST["what_tostudy_one"],
             ':what_tostudy_two'  => $_POST["what_tostudy_two"],
             ':what_tostudy_three'  => $_POST["what_tostudy_three"],
             ':where_tostudy_one'  => $_POST["where_tostudy_one"],
             ':where_tostudy_two'  => $_POST["where_tostudy_two"],
             ':where_tostudy_three'  => $_POST["where_tostudy_three"],
             ':email'  => $_POST["email"],
       );

       $query = "
       UPDATE user_academics_info_tbl 
       SET firstname = :firstname, surname = :surname, highest_qualification = :highest_qualification, current_study = :current_study, institution_name = :institution_name, academic_report = :academic_report, number_of_subjects = :number_of_subjects, what_tostudy_one = :what_tostudy_one, what_tostudy_two = :what_tostudy_two, what_tostudy_three = :what_tostudy_three, where_tostudy_one = :where_tostudy_one, where_tostudy_two = :where_tostudy_two, where_tostudy_three = :where_tostudy_three
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }

   function updateUserPreferenceInfo()
   {
    if(isset($_POST["share_details"]))
    {
       $form_data = array(
             ':promotions'  => $_POST["promotions"],
             ':share_details'  => $_POST["share_details"],
             ':whatsapp'  => $_POST["whatsapp"],
             ':communication'  => $_POST["communication"],
             ':usr_id'  => $_POST["usr_id"]
       );

       $query = "
       UPDATE user_personal_info_tbl 
       SET promotions = :promotions, share_details = :share_details, whatsapp = :whatsapp, communication = :communication
       WHERE usr_id = :usr_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  


   function deleteUserLoginInfo()
   {
    if(isset($_POST["email"]))
    {
       $form_data = array(
             ':email'  => $_POST["email"]
       );

       $query = "
       UPDATE users_logging_tbl 
       SET profile_ptc = '0'
       WHERE email = :email
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   } 


   function updateCompanyProfileInfo()
   {
    if(isset($_POST["user_type"]))
    {
       $form_data = array(
             ':user_type'  => $_POST["user_type"],
             ':db_search'  => $_POST["db_search"],
             ':bursary_portal'  => $_POST["bursary_portal"],
             ':profile_ptc'  => $_POST["profile_ptc"],
             ':update_action'  => $_POST["update_action"],             
             ':usr_detail_id'  => $_POST["usr_detail_id"]
       );

       $query = "
       UPDATE user_details_tbl 
       SET user_type = :user_type, db_search = :db_search, bursary_portal = :bursary_portal, profile_ptc = :profile_ptc, update_action = :update_action
       WHERE usr_detail_id = :usr_detail_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }   

   function addCorporateDetails()
   {
    if(isset($_POST["company_name"]))
    {
       $form_data = array(
             ':company_name'  => $_POST["company_name"],
             ':company_registration'  => $_POST["company_registration"],
             ':company_address'  => $_POST["company_address"],
             ':province'  => $_POST["province"],
             ':district'  => $_POST["district"],
             ':municipality'  => $_POST["municipality"],
             ':company_contact_number'  => $_POST["company_contact_number"],
             ':admin_firstname'  => $_POST["admin_firstname"],
             ':admin_surname'  => $_POST["admin_surname"],
             ':admin_email'  => $_POST["admin_email"],
             ':admin_contact_number'  => $_POST["admin_contact_number"],
             ':bursary_portal'  => $_POST["bursary_portal"],
             ':db_search'  => $_POST["db_search"]             
       );

       $query = "
       INSERT INTO bursary_provider_tbl 
       (company_name, company_registration, company_address, province, district, municipality, company_contact_number,admin_firstname, admin_surname, admin_email, admin_contact_number, bursary_portal, db_search) 
       VALUES 
       (:company_name, :company_registration, :company_address, :province, :district, :municipality, :company_contact_number, :admin_firstname, :admin_surname, :admin_email, :admin_contact_number, :bursary_portal, :db_search)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  


   function addUserSubject()
   {
    
    if(isset($_POST["subject"]))
    {     

       
       $form_data = array(
          ':email'  => $_POST["email"],
          ':firstname'  => $_POST["firstname"],
          ':surname'  => $_POST["surname"],
          ':academic_report'  => $_POST["academic_report"],
          ':subject'  => $_POST["subject"],
          ':mark_percentage'  => $_POST["mark_percentage"]
       );
       
       $query = "
       INSERT INTO subject_details_tbl 
       (email, firstname, surname, academic_report, subject, mark_percentage) 
       VALUES 
       (:email, :firstname, :surname, :academic_report, :subject, :mark_percentage)
       ";

       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
       }
    }
    else
    {
        $data[] = array(
           'success' => '0'
        );
     }
     return $data;
   }



   function addBursaryBeneficiaryReport()
   {
    
    if(isset($_POST["subject"]))
    {     

       
       $form_data = array(
          ':corporate'  => $_POST["corporate"],
          ':email'  => $_POST["email"],
          ':firstname'  => $_POST["firstname"],
          ':surname'  => $_POST["surname"],
          ':institution'  => $_POST["institution"],
          ':year_of_study'  => $_POST["year_of_study"],
          ':quarter'  => $_POST["quarter"],
          ':subject'  => $_POST["subject"],
          ':percentage'  => $_POST["percentage"]
       );
       
       $query = "
       INSERT INTO bursary_academics_tbl 
       (corporate, email, firstname, surname, institution, year_of_study, quarter, subject, percentage) 
       VALUES 
       (:corporate, :email, :firstname, :surname, :institution, :year_of_study, :quarter, :subject, :percentage)
       ";

       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
       }
    }
    else
    {
        $data[] = array(
           'success' => '0'
        );
     }
     return $data;
   }

   function listUserBursaryAcademics($email)
   {
      
      $data = array();

      $query = "SELECT * FROM bursary_academics_tbl WHERE email='".$email."' ORDER BY academics_id DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }


   function listAllAdminUsers($org_id)
   {
      
      $data = array();

      $query = "SELECT * FROM personal_details WHERE org_id='".$org_id."' ORDER BY profile_id DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }


   function updateUserDetails()
   {
    if(isset($_POST["firstname"]))
    {
       $form_data = array(
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':cellphone'  => $_POST["cellphone"],
             ':email'  => $_POST["email"],
             ':altenative_phone'  => $_POST["altenative_phone"],
             ':gender'  => $_POST["gender"],
             ':home_address'  => $_POST["home_address"],
             ':suburb'  => $_POST["suburb"],
             ':municipality'  => $_POST["municipality"],
             ':district'  => $_POST["district"],
             ':province'  => $_POST["province"],
             ':signature_url'  => $_POST["signature_url"],
             ':certificate_number'  => $_POST["certificate_number"],
             ':id_number'  => $_POST["id_number"]
       );

       $query = "
       UPDATE personal_details 
       SET firstname = :firstname, surname = :surname, cellphone = :cellphone, email = :email, altenative_phone = :altenative_phone, gender = :gender, home_address = :home_address, suburb = :suburb, municipality = :municipality, district = :district, province = :province, signature_url = :signature_url, certificate_number = :certificate_number
       WHERE id_number = :id_number
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }

   function viewUserDetailsByEmail($email)
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }

   function listUserDetailsByEmail($email)
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   } 

   function listAllSystemUserDetails()
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl ORDER BY usr_id DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function listAllInstitutions()
   {
      
      $data = array();

      $query = "SELECT * FROM institution_tbl ORDER BY institution_name";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   } 

   function listAllQualifications()
   {
      
      $data = array();

      $query = "SELECT * FROM qualification_tbl ORDER BY qualification_name";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }


   function listAllFaculties()
   {
      
      $data = array();

      $query = "SELECT * FROM faculty_tbl ORDER BY faculty_id";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }

   function listAllSpecializations()
   {
      
      $data = array();

      $query = "SELECT * FROM specialization_tbl ORDER BY specialization_id";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function addSpecializations()
   {
    if(isset($_POST["specialization_name"]))
    {
       $form_data = array(
             ':faculty'  => $_POST["faculty"],
             ':specialization_name'  => $_POST["specialization_name"]
       );

       $query = "
       INSERT INTO specialization_tbl 
       (faculty, specialization_name) 
       VALUES 
       (:faculty, :specialization_name)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }   

   function addFaculty()
   {
    if(isset($_POST["name"]))
    {
       $form_data = array(
             ':name'  => $_POST["name"]
       );

       $query = "
       INSERT INTO faculty_tbl 
       (name) 
       VALUES 
       (:name)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }      

   function listQualificationDetails($id)
   {
      $date = array();
      
      $query = "SELECT * FROM qualification_tbl WHERE qualification_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }     

   function listSpecializationsDetails($id)
   {
      $date = array();
      
      $query = "SELECT * FROM specialization_tbl WHERE specialization_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }

   function listFacultyDetails($id)
   {
      $date = array();
      
      $query = "SELECT * FROM faculty_tbl WHERE faculty_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   


   function updateFacultyDetails()
   {
    if(isset($_POST["name"]))
    {
       $form_data = array(
             ':name'  => $_POST["name"],
             ':faculty_id'  => $_POST["faculty_id"]
       );

       $query = "
       UPDATE faculty_tbl 
       SET name = :name
       WHERE faculty_id = :faculty_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }  


   function updateSpecializationsDetails()
   {
    if(isset($_POST["specialization_id"]))
    {
       $form_data = array(
             ':specialization_id'  => $_POST["specialization_id"],
             ':faculty'  => $_POST["faculty"],
             ':specialization_name'  => $_POST["specialization_name"]
       );

       $query = "
       UPDATE specialization_tbl 
       SET faculty = :faculty, specialization_name = :specialization_name
       WHERE specialization_id = :specialization_id
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }   

   function listLimitedSystemUserDetails()
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE email in (SELECT email FROM users_logging_tbl WHERE profile_ptc='100') ORDER BY user_personal_info_tbl.usr_id DESC LIMIT 20";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   


   function listBursaryBeneficiariesDetails($corporate)
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE email in (SELECT email FROM users_logging_tbl WHERE bursary_from='".$corporate."') ORDER BY user_personal_info_tbl.usr_id DESC LIMIT 20";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }      

   function listAllUserCompletedProfiles()
   {
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE email in (SELECT email FROM users_logging_tbl WHERE profile_ptc='100') ORDER BY user_personal_info_tbl.usr_id DESC";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  

   function listAllUserInCompleteProfiles()
   {
      
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE profile_ptc < 100 ORDER BY profile_ptc";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  


   function listSendEmailNotifications()
   {
      
      $data = array();

      $query = "SELECT * FROM sendmail_incomplete_profile WHERE profile_ptc < 100 ORDER BY profile_ptc";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }  


   function deleteIncompleteProfile($email)
   {

     $query = "DELETE FROM sendmail_incomplete_profile WHERE email = '".$email."'";
     $statement = $this->connect->prepare($query);

     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }
      
     $query = "DELETE FROM personal_details WHERE id_number = '".$id_number."'";
     $statement = $this->connect->prepare($query);
     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }

      return $data;
   }      


   function sendMailNotifications()
   {

    $data = array();  

    $query = "SELECT * FROM users_logging_tbl WHERE profile_ptc < 100 AND user_type='user'";

    $statement = $this->connect->prepare($query);

    if($statement->execute())
    {
       foreach($statement->fetchAll() as $row)
       {
          $data['firstname'] = $row['firstname'];
          $data['surname'] = $row['surname'];
          $data['email'] = $row['email'];
       }

       return $data;
     }
   }



   function listAllCorporateUsers()
   {
      
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE user_type = 'corporate'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   } 

   function listAllSuperUsers()
   {
      
      $data = array();

      $query = "SELECT * FROM users_logging_tbl WHERE user_type = 'super'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }                     

   function listUserAcademicsByEmail($email)
   {
      
      $data = array();

      $query = "SELECT * FROM user_academics_info_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   } 

   function listUserSubjectResults($email)
   {
      $data = array();
      
      $query = "SELECT * FROM subject_details_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }      

   function listUserDetailsByRow($id)
   {
      $query = "SELECT * FROM user_details_tbl WHERE usr_detail_id='".$id."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   

   function deleteUser($id_number)
   {

     $query = "DELETE FROM authentication WHERE id_number = '".$id_number."'";
     $statement = $this->connect->prepare($query);

     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }
      
     $query = "DELETE FROM personal_details WHERE id_number = '".$id_number."'";
     $statement = $this->connect->prepare($query);
     if($statement->execute())
     {
      $data[] = array(
          'success' => '1'
         );
      }
      else
      {
      $data[] = array(
          'success' => '0'
          );
      }

      return $data;
   }

   function addBursaryPayment()
   {
    if(isset($_POST["corporate"]))
    {
       $form_data = array(
             ':corporate'  => $_POST["corporate"],
             ':firstname'  => $_POST["firstname"],
             ':surname'  => $_POST["surname"],
             ':email'  => $_POST["email"],
             ':whatsapp'  => $_POST["whatsapp"],
             ':alt_number'  => $_POST["alt_number"],
             ':year'  => $_POST["year"],
             ':trunche'  => $_POST["trunche"],
             ':amount'  => $_POST["amount"]
       );

       $query = "
       INSERT INTO corporate_finance_tbl 
       (corporate, firstname, surname, email, whatsapp, alt_number, year, trunche, amount) 
       VALUES 
       (:corporate, :firstname, :surname, :email, :whatsapp, :alt_number, :year, :trunche, :amount)
       ";
       
       $statement = $this->connect->prepare($query);
       if($statement->execute($form_data))
       {
          $data[] = array(
             'success' => '1'
          );
       }
       else
       {
          $data[] = array(
             'success' => '0'
          );
          }
       }
       else
       {
        $data[] = array(
           'success' => '0'
        );
      }
      return $data;
   }


   function searchWithParameters($province, $gender, $race, $disability)
   {

      if($gender == "Male"){

         $search_gender = 'Male';

      } else if($gender == "Female") {

         $search_gender = 'Female';

      } else {

         $search_gender = '%';
         
      }

      if($province == "Any"){

         $search_province = '%';

      } else {

         $search_province = '%'.$province.'%';

      }      

      
      if($race == "Any"){

         $search_race = '%';

      } else {

         $search_race = '%'.$race.'%';

      }     

            
      if($disability == "Any"){

         $search_disability = '%';

      } else {

         $search_disability = '%'.$disability.'%';

      }    



      
      
      $data = array();

      $query = "SELECT * FROM user_personal_info_tbl WHERE province LIKE '".$search_province."' AND gender LIKE '".$search_gender."' AND race LIKE '".$search_race."' AND disability LIKE '".$search_disability."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }   


   function searchForName($name)
   {

      $search = '%'.$name.'%';
      
      $data = array();

      $query = "SELECT * FROM users_logging_tbl details WHERE CONCAT(details.firstname, ' ', details.surname) LIKE '".$search."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
            $data[] = $row;
         }
         return $data;
      }
   }                        

      // Add this method to get registration trends data
   function getRegistrationTrends()
   {
      $data = array();
      
      // Get registration counts for the last 12 months
      $query = "SELECT 
         YEAR(create_date) as year,
         MONTH(create_date) as month,
         COUNT(*) as registrations
         FROM users_logging_tbl 
         WHERE create_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
         GROUP BY YEAR(create_date), MONTH(create_date)
         ORDER BY year, month";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Add this method to get user distribution data
   function getUserDistribution()
   {
      $data = array();
      
      $query = "SELECT 
         user_type,
         COUNT(*) as count
         FROM users_logging_tbl 
         WHERE profile_ptc > 0
         GROUP BY user_type";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Add bursary program
   function addBursaryProgram()
   {
      if(isset($_POST["funder_name"]))
      {
         $form_data = array(
               ':funder_name'  => $_POST["funder_name"],
               ':project_name'  => $_POST["project_name"],
               ':contact_person'  => $_POST["contact_person"],
               ':contact_email'  => $_POST["contact_email"],
               ':contact_phone'  => $_POST["contact_phone"],
               ':application_end_date'  => $_POST["application_end_date"],
               ':funding_amount'  => $_POST["funding_amount"],
               ':field_of_study'  => $_POST["field_of_study"],
               ':academic_requirements'  => $_POST["academic_requirements"],
               ':demographic_filters'  => $_POST["demographic_filters"],
               ':basic_requirements'  => $_POST["basic_requirements"],
               ':terms_conditions'  => $_POST["terms_conditions"],
               ':created_by'  => $_POST["created_by"]
         );

         $query = "
         INSERT INTO bursaries_tbl 
         (funder_name, project_name, contact_person, contact_email, contact_phone, application_end_date, funding_amount, field_of_study, academic_requirements, demographic_filters, basic_requirements, terms_conditions, created_by) 
         VALUES 
         (:funder_name, :project_name, :contact_person, :contact_email, :contact_phone, :application_end_date, :funding_amount, :field_of_study, :academic_requirements, :demographic_filters, :basic_requirements, :terms_conditions, :created_by)
         ";
         
         $statement = $this->connect->prepare($query);
         if($statement->execute($form_data))
         {
            $data[] = array(
               'success' => '1'
            );
         }
         else
         {
            $data[] = array(
               'success' => '0'
            );
         }
      }
      else
      {
         $data[] = array(
            'success' => '0'
         );
      }
      return $data;
   }

   // Get all bursaries
   function getAllBursaries()
   {
      $data = array();
      
      $query = "SELECT * FROM bursaries_tbl ORDER BY application_end_date DESC";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               // Update status based on end date
               $end_date = new DateTime($row['application_end_date']);
               $today = new DateTime();
               $status = $end_date >= $today ? 'active' : 'expired';
               
               // Update status if changed
               if($row['status'] != $status) {
                  $update_query = "UPDATE bursaries_tbl SET status = :status WHERE bursary_id = :id";
                  $update_stmt = $this->connect->prepare($update_query);
                  $update_stmt->execute(array(':status' => $status, ':id' => $row['bursary_id']));
                  $row['status'] = $status;
               }
               
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Get active bursaries for dashboard
   function getActiveBursaries()
   {
      $data = array();
      
      $query = "SELECT * FROM bursaries_tbl WHERE status = 'active' ORDER BY application_end_date ASC LIMIT 5";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Get bursary by ID
   function getBursaryById($id)
   {
      $data = array();
      
      $query = "SELECT * FROM bursaries_tbl WHERE bursary_id = :id";
      
      $statement = $this->connect->prepare($query);
      $statement->execute(array(':id' => $id));
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Update bursary program
   function updateBursaryProgram()
   {
      if(isset($_POST["bursary_id"]))
      {
         $form_data = array(
               ':bursary_id'  => $_POST["bursary_id"],
               ':funder_name'  => $_POST["funder_name"],
               ':project_name'  => $_POST["project_name"],
               ':contact_person'  => $_POST["contact_person"],
               ':contact_email'  => $_POST["contact_email"],
               ':contact_phone'  => $_POST["contact_phone"],
               ':application_end_date'  => $_POST["application_end_date"],
               ':funding_amount'  => $_POST["funding_amount"],
               ':field_of_study'  => $_POST["field_of_study"],
               ':academic_requirements'  => $_POST["academic_requirements"],
               ':demographic_filters'  => $_POST["demographic_filters"],
               ':basic_requirements'  => $_POST["basic_requirements"],
               ':terms_conditions'  => $_POST["terms_conditions"]
         );

         $query = "
         UPDATE bursaries_tbl 
         SET funder_name = :funder_name, project_name = :project_name, contact_person = :contact_person, 
            contact_email = :contact_email, contact_phone = :contact_phone, application_end_date = :application_end_date,
            funding_amount = :funding_amount, field_of_study = :field_of_study, academic_requirements = :academic_requirements,
            demographic_filters = :demographic_filters, basic_requirements = :basic_requirements, 
            terms_conditions = :terms_conditions
         WHERE bursary_id = :bursary_id
         ";
         
         $statement = $this->connect->prepare($query);
         if($statement->execute($form_data))
         {
            $data[] = array(
               'success' => '1'
            );
         }
         else
         {
            $data[] = array(
               'success' => '0'
            );
         }
      }
      else
      {
         $data[] = array(
            'success' => '0'
         );
      }
      return $data;
   }

   // Delete bursary program
   function deleteBursaryProgram($id)
   {
      $query = "DELETE FROM bursaries_tbl WHERE bursary_id = :id";
      $statement = $this->connect->prepare($query);
      
      if($statement->execute(array(':id' => $id)))
      {
         $data[] = array(
               'success' => '1'
         );
      }
      else
      {
         $data[] = array(
               'success' => '0'
         );
      }
      
      return $data;
   }

   // Get bursaries by funder
   function getBursariesByFunder($funder_name)
   {
      $data = array();
      
      $query = "SELECT * FROM bursaries_tbl WHERE funder_name = :funder_name ORDER BY application_end_date DESC";
      
      $statement = $this->connect->prepare($query);
      $statement->execute(array(':funder_name' => $funder_name));
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               // Update status based on end date
               $end_date = new DateTime($row['application_end_date']);
               $today = new DateTime();
               $status = $end_date >= $today ? 'active' : 'expired';
               
               // Update status if changed
               if($row['status'] != $status) {
                  $update_query = "UPDATE bursaries_tbl SET status = :status WHERE bursary_id = :id";
                  $update_stmt = $this->connect->prepare($update_query);
                  $update_stmt->execute(array(':status' => $status, ':id' => $row['bursary_id']));
                  $row['status'] = $status;
               }
               
               $data[] = $row;
         }
      }
      
      return $data;
   }   


   // Get bursary applications for a company
   function getBursaryApplications($company_name)
   {
      $data = array();
      
      $query = "SELECT a.*, b.project_name, b.funder_name, u.firstname, u.surname, u.email, u.gender 
               FROM bursary_applications_tbl a 
               JOIN bursaries_tbl b ON a.bursary_id = b.bursary_id 
               JOIN users_logging_tbl u ON a.user_email = u.email 
               WHERE b.funder_name = :company_name 
               ORDER BY a.application_date DESC";
      
      $statement = $this->connect->prepare($query);
      $statement->execute(array(':company_name' => $company_name));
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }

   // Get bursary application statistics
   function getBursaryApplicationStats($company_name)
   {
      $data = array();
      
      $query = "SELECT 
                  COUNT(*) as total,
                  SUM(CASE WHEN a.status = 'pending' THEN 1 ELSE 0 END) as pending,
                  SUM(CASE WHEN a.status = 'approved' THEN 1 ELSE 0 END) as approved,
                  SUM(CASE WHEN a.status = 'rejected' THEN 1 ELSE 0 END) as rejected,
                  SUM(CASE WHEN a.status = 'shortlisted' THEN 1 ELSE 0 END) as shortlisted
               FROM bursary_applications_tbl a 
               JOIN bursaries_tbl b ON a.bursary_id = b.bursary_id 
               WHERE b.funder_name = :company_name";
      
      $statement = $this->connect->prepare($query);
      $statement->execute(array(':company_name' => $company_name));
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
      }
      
      return $data;
   }   

   function getMonthlyBeneficiaries($corporate)
   {
      $data = array();

      $query = "SELECT 
                  DATE_FORMAT(create_date, '%b') as month, 
                  COUNT(*) as count 
               FROM users_logging_tbl 
               WHERE bursary_from = '".$corporate."' 
               GROUP BY YEAR(create_date), MONTH(create_date) 
               ORDER BY YEAR(create_date), MONTH(create_date)";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }

   function getGenderDistribution($corporate)
   {
      $data = array();

      $query = "SELECT 
                  up.gender, 
                  COUNT(*) as count 
               FROM user_personal_info_tbl up
               INNER JOIN users_logging_tbl ul ON up.email = ul.email
               WHERE ul.bursary_from = '".$corporate."' 
               GROUP BY up.gender";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }

   function getPaymentTrends($corporate)
   {
      $data = array();

      $query = "SELECT 
                  DATE_FORMAT(created_date, '%b') as month, 
                  SUM(amount) as amount 
               FROM corporate_finance_tbl 
               WHERE corporate = '".$corporate."' 
               GROUP BY YEAR(created_date), MONTH(created_date) 
               ORDER BY YEAR(created_date), MONTH(created_date)";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }   

   function listUserAcademics($email)
   {
      $data = array();

      $query = "SELECT * FROM user_academics_info_tbl WHERE email='".$email."'";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }

   function updateUserRole()
   {
      if(isset($_POST["email"]))
      {
         $form_data = array(
               ':user_type'  => $_POST["user_type"],
               ':action'  => $_POST["action"],
               ':email'  => $_POST["email"]
         );

         $query = "
         UPDATE users_logging_tbl 
         SET user_type = :user_type, action = :action
         WHERE email = :email
         ";
         
         $statement = $this->connect->prepare($query);
         if($statement->execute($form_data))
         {
               $data[] = array(
                  'success' => '1'
               );
         }
         else
         {
               $data[] = array(
                  'success' => '0'
               );
         }
      }
      else
      {
         $data[] = array(
               'success' => '0'
         );
      }
      return $data;
   }

   function getDemographicStats($corporate)
   {
      $data = array();

      $query = "SELECT 
                  gender, COUNT(*) as count 
               FROM user_personal_info_tbl up
               INNER JOIN users_logging_tbl ul ON up.email = ul.email
               WHERE ul.bursary_from = '".$corporate."' 
               GROUP BY gender";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }

   function getFinancialStats($corporate)
   {
      $data = array();

      $query = "SELECT 
                  year, trunche, SUM(amount) as total_amount 
               FROM corporate_finance_tbl 
               WHERE corporate = '".$corporate."' 
               GROUP BY year, trunche 
               ORDER BY year, trunche";

      $statement = $this->connect->prepare($query);

      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }
   
   function updateCorporateProfile()
   {
      if(isset($_POST["company_name"]))
      {
         $form_data = array(
               ':company_name'  => $_POST["company_name"],
               ':company_registration'  => $_POST["company_registration"],
               ':company_address'  => $_POST["company_address"],
               ':company_contact_number'  => $_POST["company_contact_number"],
               ':province'  => $_POST["province"],
               ':district'  => $_POST["district"],
               ':municipality'  => $_POST["municipality"],
               ':bur_prv_id'  => $_POST["bur_prv_id"]
         );

         $query = "
         UPDATE bursary_provider_tbl 
         SET company_name = :company_name, company_registration = :company_registration, 
               company_address = :company_address, company_contact_number = :company_contact_number,
               province = :province, district = :district, municipality = :municipality
         WHERE bur_prv_id = :bur_prv_id
         ";
         
         $statement = $this->connect->prepare($query);
         if($statement->execute($form_data))
         {
               $data[] = array(
                  'success' => '1'
               );
         }
         else
         {
               $data[] = array(
                  'success' => '0'
               );
         }
      }
      else
      {
         $data[] = array(
               'success' => '0'
         );
      }
      return $data;
   }

   function updateCorporatePreferences()
   {
      if(isset($_POST["bursary_portal"]))
      {
         $form_data = array(
               ':bursary_portal'  => $_POST["bursary_portal"],
               ':db_search'  => $_POST["db_search"],
               ':bur_prv_id'  => $_POST["bur_prv_id"]
         );

         $query = "
         UPDATE bursary_provider_tbl 
         SET bursary_portal = :bursary_portal, db_search = :db_search
         WHERE bur_prv_id = :bur_prv_id
         ";
         
         $statement = $this->connect->prepare($query);
         if($statement->execute($form_data))
         {
               $data[] = array(
                  'success' => '1'
               );
         }
         else
         {
               $data[] = array(
                  'success' => '0'
               );
         }
      }
      else
      {
         $data[] = array(
               'success' => '0'
         );
      }
      return $data;
   }   

   function getMonthlyFundingData($corporate)
   {
      $data = array();
      $current_year = date('Y');
      
      $query = "SELECT 
                  MONTH(created_date) as month, 
                  SUM(amount) as total_amount 
               FROM corporate_finance_tbl 
               WHERE corporate = '".$corporate."' 
               AND YEAR(created_date) = '".$current_year."'
               GROUP BY MONTH(created_date) 
               ORDER BY MONTH(created_date)";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }

   function getYearlyFundingData($corporate)
   {
      $data = array();
      
      $query = "SELECT 
                  year, 
                  SUM(amount) as total_amount 
               FROM corporate_finance_tbl 
               WHERE corporate = '".$corporate."' 
               GROUP BY year 
               ORDER BY year";
      
      $statement = $this->connect->prepare($query);
      
      if($statement->execute())
      {
         while($row = $statement->fetch(PDO::FETCH_ASSOC))
         {
               $data[] = $row;
         }
         return $data;
      }
   }   


}
?>


